/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.member.bytecode;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.LiteralType;
import youyihj.zenutils.impl.member.TypeData;
import youyihj.zenutils.impl.member.bytecode.BytecodeClassDataFetcher;
import youyihj.zenutils.impl.member.reflect.ReflectionClassData;

public class BytecodeTypeData
implements TypeData {
    private final String descriptor;
    private final String genericInfo;
    private final BytecodeClassDataFetcher classDataFetcher;

    BytecodeTypeData(String descriptor, String genericInfo, BytecodeClassDataFetcher classDataFetcher) {
        this.descriptor = descriptor;
        this.genericInfo = genericInfo;
        this.classDataFetcher = classDataFetcher;
    }

    @Override
    public Type javaType() {
        return new LiteralType(this);
    }

    @Override
    public String descriptor() {
        return this.descriptor;
    }

    @Override
    public ClassData asClassData() {
        try {
            if (this.descriptor.startsWith("L")) {
                return this.classDataFetcher.forName(this.descriptor.substring(1, this.descriptor.length() - 1));
            }
            if (this.descriptor.startsWith("[")) {
                return ReflectionClassData.of(Array.newInstance(Object.class, new int[this.descriptor.lastIndexOf(91) + 1]).getClass());
            }
            return this.classDataFetcher.forName(this.descriptor);
        }
        catch (ClassNotFoundException e) {
            return this.classDataFetcher.forClass(Object.class);
        }
    }

    public String toString() {
        return this.genericInfo != null ? this.genericInfo : this.descriptor;
    }
}

