/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.member.bytecode;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.TypeData;
import youyihj.zenutils.impl.member.bytecode.BytecodeAnnotatedMember;
import youyihj.zenutils.impl.member.bytecode.BytecodeClassData;
import youyihj.zenutils.impl.member.bytecode.MethodParameterParser;

public class BytecodeMethodData
extends BytecodeAnnotatedMember
implements ExecutableData {
    private final MethodNode methodNode;
    private final BytecodeClassData declaringClass;
    private TypeData returnType;
    private List<TypeData> parameters;

    public BytecodeMethodData(MethodNode methodNode, BytecodeClassData declaringClass) {
        this.methodNode = methodNode;
        this.declaringClass = declaringClass;
        this.setAnnotationNodes(methodNode.visibleAnnotations);
        this.setAnnotationNodes(methodNode.invisibleAnnotations);
    }

    @Override
    public String name() {
        return this.methodNode.name;
    }

    @Override
    public ClassData declaringClass() {
        return this.declaringClass;
    }

    @Override
    public int parameterCount() {
        return Type.getMethodType((String)this.methodNode.desc).getArgumentTypes().length;
    }

    @Override
    public int modifiers() {
        return this.methodNode.access;
    }

    @Override
    public TypeData returnType() {
        if (this.returnType == null) {
            String returnAndException;
            String signature = this.methodNode.signature;
            String descriptor = Type.getReturnType((String)this.methodNode.desc).getDescriptor();
            this.returnType = signature == null ? this.declaringClass.getClassDataFetcher().type(descriptor, null) : ((returnAndException = signature.substring(signature.indexOf(41) + 1)).contains("^") ? this.declaringClass.getClassDataFetcher().type(descriptor, signature.substring(0, signature.indexOf(94))) : this.declaringClass.getClassDataFetcher().type(descriptor, returnAndException));
        }
        return this.returnType;
    }

    @Override
    public List<TypeData> parameters() {
        block4: {
            if (this.parameters != null) break block4;
            this.parameters = new ArrayList<TypeData>();
            if (this.methodNode.signature == null) {
                for (Type parameter : Type.getMethodType((String)this.methodNode.desc).getArgumentTypes()) {
                    this.parameters.add(this.declaringClass.getClassDataFetcher().type(parameter.getDescriptor(), null));
                }
            } else {
                List<String> genericInfos = new MethodParameterParser(this.methodNode.signature).parse();
                Type[] descriptors = Type.getMethodType((String)this.methodNode.desc).getArgumentTypes();
                for (int i = 0; i < descriptors.length; ++i) {
                    this.parameters.add(this.declaringClass.getClassDataFetcher().type(descriptors[i].getDescriptor(), genericInfos.get(i)));
                }
            }
        }
        return this.parameters;
    }

    @Override
    public boolean isVarArgs() {
        return (this.methodNode.access & 0x80) != 0;
    }

    @Override
    public String descriptor() {
        return this.methodNode.desc;
    }
}

