/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.member.bytecode;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ClassDataFetcher;
import youyihj.zenutils.impl.member.TypeData;
import youyihj.zenutils.impl.member.bytecode.BytecodeClassData;
import youyihj.zenutils.impl.member.bytecode.BytecodeTypeData;
import youyihj.zenutils.impl.member.reflect.ReflectionClassData;

public class BytecodeClassDataFetcher
implements ClassDataFetcher,
Closeable {
    private final List<FileSystem> jars = new ArrayList<FileSystem>();
    private final Map<String, ClassData> cache = new HashMap<String, ClassData>();
    private final Set<String> absentTries = new HashSet<String>();
    private final ClassDataFetcher parent;
    private boolean closed;

    public BytecodeClassDataFetcher(ClassDataFetcher parent, List<Path> classpath) {
        this.parent = parent;
        this.cache.put("I", ReflectionClassData.of(Integer.TYPE));
        this.cache.put("J", ReflectionClassData.of(Long.TYPE));
        this.cache.put("F", ReflectionClassData.of(Float.TYPE));
        this.cache.put("D", ReflectionClassData.of(Double.TYPE));
        this.cache.put("Z", ReflectionClassData.of(Boolean.TYPE));
        this.cache.put("S", ReflectionClassData.of(Short.TYPE));
        this.cache.put("B", ReflectionClassData.of(Byte.TYPE));
        this.cache.put("C", ReflectionClassData.of(Character.TYPE));
        this.cache.put("V", ReflectionClassData.of(Void.TYPE));
        try {
            for (Path path : classpath) {
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (file.getFileName().toString().endsWith(".jar")) {
                            BytecodeClassDataFetcher.this.jars.add(FileSystems.newFileSystem(file, null));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read a jar of classpath", e);
        }
    }

    @Override
    public ClassData forName(String className) throws ClassNotFoundException {
        if (this.cache.containsKey(className)) {
            return this.cache.get(className);
        }
        if (this.absentTries.contains(className)) {
            throw new ClassNotFoundException(className);
        }
        try {
            ClassData classData = this.findClass(className);
            this.cache.put(className, classData);
            return classData;
        }
        catch (ClassNotFoundException e) {
            this.absentTries.add(className);
            throw e;
        }
    }

    @Override
    public ClassData forClass(Class<?> clazz) {
        try {
            return this.forName(clazz.getName());
        }
        catch (ClassNotFoundException e) {
            return ReflectionClassData.of(clazz);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        for (FileSystem jar : this.jars) {
            jar.close();
        }
    }

    TypeData type(String descriptor, String genericInfo) {
        if (descriptor.startsWith("L") || descriptor.length() == 1) {
            try {
                return this.forName(descriptor);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new BytecodeTypeData(descriptor, genericInfo, this);
    }

    private ClassData findClass(String className) throws ClassNotFoundException {
        if (!this.closed) {
            String[] split = className.split("\\.");
            String first = split[0];
            String[] more = new String[split.length - 1];
            System.arraycopy(split, 1, more, 0, more.length);
            if (more.length > 0) {
                more[more.length - 1] = more[more.length - 1] + ".class";
            } else {
                first = first + ".class";
            }
            for (FileSystem jar : this.jars) {
                Path classPath = jar.getPath(first, more);
                if (!Files.exists(classPath, new LinkOption[0])) continue;
                try {
                    return new BytecodeClassData(Files.readAllBytes(classPath), this);
                }
                catch (IOException iOException) {
                }
            }
        }
        return this.parent.forName(className);
    }
}

