/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.member.bytecode;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import youyihj.zenutils.impl.member.ClassData;
import youyihj.zenutils.impl.member.ExecutableData;
import youyihj.zenutils.impl.member.FieldData;
import youyihj.zenutils.impl.member.LiteralType;
import youyihj.zenutils.impl.member.LookupRequester;
import youyihj.zenutils.impl.member.bytecode.BytecodeAnnotatedMember;
import youyihj.zenutils.impl.member.bytecode.BytecodeClassDataFetcher;
import youyihj.zenutils.impl.member.bytecode.BytecodeFieldData;
import youyihj.zenutils.impl.member.bytecode.BytecodeMethodData;

public class BytecodeClassData
extends BytecodeAnnotatedMember
implements ClassData {
    private final byte[] bytecode;
    private final BytecodeClassDataFetcher classDataFetcher;
    private final ClassNode classNode;
    private final Map<LookupRequester, List<FieldData>> fieldsCache = new EnumMap<LookupRequester, List<FieldData>>(LookupRequester.class);
    private final Map<LookupRequester, List<ExecutableData>> methodsCache = new EnumMap<LookupRequester, List<ExecutableData>>(LookupRequester.class);
    private final Map<LookupRequester, List<ExecutableData>> constructorsCache = new EnumMap<LookupRequester, List<ExecutableData>>(LookupRequester.class);

    public BytecodeClassData(byte[] bytecode, BytecodeClassDataFetcher classDataFetcher) {
        this.bytecode = bytecode;
        this.classDataFetcher = classDataFetcher;
        this.classNode = new ClassNode();
        new ClassReader(bytecode).accept((ClassVisitor)this.classNode, 1);
        this.setAnnotationNodes(this.classNode.visibleAnnotations);
        this.setAnnotationNodes(this.classNode.invisibleAnnotations);
    }

    @Override
    public String name() {
        return this.classNode.name.replace('/', '.');
    }

    @Override
    public String internalName() {
        return this.classNode.name;
    }

    @Override
    public List<FieldData> fields(LookupRequester requester) {
        return this.fieldsCache.computeIfAbsent(requester, this::fields0);
    }

    private List<FieldData> fields0(LookupRequester requester) {
        ArrayList<FieldData> fieldData = new ArrayList<FieldData>();
        for (FieldNode field : this.classNode.fields) {
            if (!requester.allows(field.access)) continue;
            fieldData.add(new BytecodeFieldData(field, this));
        }
        ClassData superClass = this.superClass();
        if (superClass != null) {
            fieldData.addAll(superClass.fields(requester));
        }
        return fieldData;
    }

    @Override
    public List<ExecutableData> methods(LookupRequester requester) {
        return this.methodsCache.computeIfAbsent(requester, this::methods0);
    }

    private List<ExecutableData> methods0(LookupRequester requester) {
        ArrayList<ExecutableData> methods = new ArrayList<ExecutableData>();
        HashSet<String> usedDescriptions = new HashSet<String>();
        for (MethodNode method : this.classNode.methods) {
            if (method.name.startsWith("<") || !requester.allows(method.access)) continue;
            BytecodeMethodData methodData = new BytecodeMethodData(method, this);
            methods.add(methodData);
            usedDescriptions.add(methodData.name() + methodData.descriptor());
        }
        ClassData superClass = this.superClass();
        if (superClass != null) {
            for (ExecutableData superMethod : superClass.methods(requester)) {
                if (!usedDescriptions.add(superMethod.name() + superMethod.descriptor())) continue;
                methods.add(superMethod);
            }
        }
        for (ClassData anInterface : this.interfaces()) {
            List<ExecutableData> interfaceMethods = anInterface.methods(requester);
            for (ExecutableData interfaceMethod : interfaceMethods) {
                if (!usedDescriptions.add(interfaceMethod.name() + interfaceMethod.descriptor())) continue;
                methods.add(interfaceMethod);
            }
        }
        return methods;
    }

    @Override
    public List<ExecutableData> constructors(LookupRequester requester) {
        return this.constructorsCache.computeIfAbsent(requester, this::constructors0);
    }

    private List<ExecutableData> constructors0(LookupRequester requester) {
        ArrayList<ExecutableData> constructors = new ArrayList<ExecutableData>();
        for (MethodNode method : this.classNode.methods) {
            if (!method.name.equals("<init>") || !requester.allows(method.access)) continue;
            constructors.add(new BytecodeMethodData(method, this));
        }
        return constructors;
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(this.classNode.access);
    }

    @Override
    public boolean isAssignableFrom(ClassData classData) {
        if (this.name().equals(classData.name())) {
            return true;
        }
        List<ClassData> interfaces = classData.interfaces();
        for (ClassData anInterface : interfaces) {
            if (!this.name().equals(anInterface.name())) continue;
            return true;
        }
        ClassData superClass = classData.superClass();
        if (superClass != null) {
            return this.isAssignableFrom(superClass);
        }
        return false;
    }

    @Override
    @Nullable
    public ClassData superClass() {
        try {
            return this.classDataFetcher.forName(this.classNode.superName.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<ClassData> interfaces() {
        ArrayList<ClassData> interfaces = new ArrayList<ClassData>();
        for (String anInterface : this.classNode.interfaces) {
            try {
                interfaces.add(this.classDataFetcher.forName(anInterface.replace('/', '.')));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return interfaces;
    }

    @Override
    public Type javaType() {
        return new LiteralType(this);
    }

    @Override
    public String descriptor() {
        return "L" + this.internalName() + ";";
    }

    @Override
    public ClassData asClassData() {
        return this;
    }

    public byte[] getBytecode() {
        return this.bytecode;
    }

    public BytecodeClassDataFetcher getClassDataFetcher() {
        return this.classDataFetcher;
    }

    public String toString() {
        return this.descriptor();
    }
}

