/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.member.bytecode;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import youyihj.zenutils.impl.member.AnnotatedMember;

public class BytecodeAnnotatedMember
implements AnnotatedMember {
    private final List<AnnotationNode> annotationNodes = new ArrayList<AnnotationNode>();

    protected BytecodeAnnotatedMember() {
    }

    protected void setAnnotationNodes(List<AnnotationNode> annotationNodes) {
        if (annotationNodes != null) {
            this.annotationNodes.addAll(annotationNodes);
        }
    }

    @Override
    public <A extends Annotation> boolean isAnnotationPresent(Class<A> annotationClass) {
        for (AnnotationNode annotation : this.annotationNodes) {
            if (!Objects.equals(annotation.desc, Type.getDescriptor(annotationClass))) continue;
            return true;
        }
        return false;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        for (AnnotationNode annotation : this.annotationNodes) {
            if (!Objects.equals(annotation.desc, Type.getDescriptor(annotationClass))) continue;
            ClassLoader annotationClassLoader = annotationClass.getClassLoader();
            return (A)((Annotation)Proxy.newProxyInstance(annotationClassLoader, new Class[]{annotationClass}, (proxy, method, args) -> {
                List values = annotation.values;
                if (values != null) {
                    for (int i = 0; i < values.size(); i += 2) {
                        if (!Objects.equals(values.get(i), method.getName())) continue;
                        return this.parseAnnotationValue(values.get(i + 1), annotationClassLoader);
                    }
                }
                if (method.getName().equals("annotationType")) {
                    return annotationClass;
                }
                return method.getDefaultValue();
            }));
        }
        return null;
    }

    private Object parseAnnotationValue(Object value, ClassLoader classLoader) throws Exception {
        if (value.getClass() == Type.class) {
            return this.convertASMType((Type)value, classLoader);
        }
        if (value instanceof List) {
            List list = (List)value;
            Object[] values = new Object[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                values[i] = this.parseAnnotationValue(list.get(i), classLoader);
            }
            return values;
        }
        if (value instanceof String[]) {
            String[] strings = (String[])value;
            return Enum.valueOf(Class.forName(Type.getType((String)strings[0]).getClassName(), true, classLoader), strings[1]);
        }
        return value;
    }

    private Class<?> convertASMType(Type type, ClassLoader classLoader) {
        try {
            switch (type.getSort()) {
                case 0: {
                    return Void.TYPE;
                }
                case 1: {
                    return Boolean.TYPE;
                }
                case 3: {
                    return Byte.TYPE;
                }
                case 4: {
                    return Short.TYPE;
                }
                case 5: {
                    return Integer.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: {
                    return Long.TYPE;
                }
                case 8: {
                    return Double.TYPE;
                }
                case 9: {
                    Type elementType = type.getElementType();
                    int dimensions = type.getDimensions();
                    return Array.newInstance(this.convertASMType(elementType, classLoader), new int[dimensions]).getClass();
                }
                case 10: {
                    return Class.forName(type.getClassName(), false, classLoader);
                }
            }
            return Object.class;
        }
        catch (ClassNotFoundException e) {
            return Object.class;
        }
    }
}

