/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityDefinition;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IVector3d;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import youyihj.zenutils.api.entity.IEntityPredicate;
import youyihj.zenutils.api.entity.INearbyEntityList;

public class NearbyEntityList
implements INearbyEntityList {
    private final World world;
    private final IVector3d pos;
    private final double radius;
    private Predicate<IEntity> predicate = Predicates.alwaysTrue();
    private final Entity exclude;

    public NearbyEntityList(World world, IVector3d pos, double radius, IEntity exclude) {
        this.world = world;
        this.pos = pos;
        this.radius = radius;
        this.exclude = CraftTweakerMC.getEntity((IEntity)exclude);
    }

    @Override
    public INearbyEntityList filterType(IEntityDefinition definition) {
        this.predicate = Predicates.and(this.predicate, it -> Objects.equals(it.getDefinition(), definition));
        return this;
    }

    @Override
    public INearbyEntityList filter(IEntityPredicate predicate) {
        this.predicate = Predicates.and(this.predicate, predicate::test);
        return this;
    }

    @Override
    public List<IEntity> entities() {
        return this.getEntities(Entity.class, CraftTweakerMC::getIEntity, false);
    }

    @Override
    public List<IEntityLivingBase> livings() {
        return this.getEntities(EntityLivingBase.class, CraftTweakerMC::getIEntityLivingBase, false);
    }

    @Override
    public List<IPlayer> players() {
        return this.getEntities(EntityPlayer.class, CraftTweakerMC::getIPlayer, true);
    }

    @Override
    public List<IEntityItem> items() {
        return this.getEntities(EntityItem.class, CraftTweakerMC::getIEntityItem, false);
    }

    @Override
    public IEntity closestEntity() {
        return NearbyEntityList.firstOrNull(this.entities());
    }

    @Override
    public IEntityLivingBase closestLiving() {
        return NearbyEntityList.firstOrNull(this.livings());
    }

    @Override
    public IPlayer closestPlayer() {
        return NearbyEntityList.firstOrNull(this.players());
    }

    @Override
    public IEntityItem closestItem() {
        return NearbyEntityList.firstOrNull(this.items());
    }

    private Predicate<Entity> mcPredicate() {
        return Predicates.compose(this.predicate, CraftTweakerMC::getIEntity);
    }

    private <M extends Entity, C extends IEntity> List<C> getEntities(Class<M> mcEntityClass, Function<M, C> crtMapper, boolean player) {
        List entities = player ? this.world.func_175661_b(mcEntityClass, this.mcPredicate()) : this.world.func_175644_a(mcEntityClass, this.mcPredicate());
        return entities.stream().map(e -> Pair.of((Object)e, (Object)e.func_70092_e(this.pos.getX(), this.pos.getY(), this.pos.getZ()))).filter((? super T it) -> (Double)it.getRight() <= this.radius * this.radius).filter((? super T it) -> this.exclude == null || it.getLeft() != this.exclude).sorted(Comparator.comparingDouble(Pair::getRight)).map(Pair::getLeft).map(crtMapper).collect(Collectors.toList());
    }

    private static <T> T firstOrNull(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(0);
    }
}

