/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.impl.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import youyihj.zenutils.api.entity.IEntityTick;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.ICatenationBuilder;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationFactory;
import youyihj.zenutils.api.world.ZenUtilsWorld;

@Mod.EventBusSubscriber
public class EntityTickDispatcher {
    private static final Multimap<Entity, Catenation> catenations = Multimaps.newListMultimap(new WeakHashMap(), ArrayList::new);
    private static final Multimap<Class<? extends Entity>, Function<Entity, ICatenationFactory>> catenationFactories = HashMultimap.create();

    public static void register(Class<? extends Entity> entityClass, IEntityTick operation, int interval) {
        int actualInterval = Math.max(0, interval - 2);
        MutableObject ref = new MutableObject();
        ref.setValue(arg_0 -> EntityTickDispatcher.lambda$register$4(actualInterval, operation, (Mutable)ref, arg_0));
        catenationFactories.put(entityClass, ref.getValue());
    }

    public static void clearCatenationFactories() {
        catenationFactories.clear();
    }

    public static void restartCatenations() {
        catenations.values().forEach(Catenation::stop);
        HashSet entities = new HashSet(catenations.keySet());
        catenations.clear();
        entities.forEach(EntityTickDispatcher::startCatenation);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        EntityTickDispatcher.startCatenation(entity);
    }

    private static void startCatenation(Entity entity) {
        for (Function factoryFactory : catenationFactories.get(entity.getClass())) {
            ((ICatenationFactory)factoryFactory.apply(entity)).get(CraftTweakerMC.getIWorld((World)entity.field_70170_p));
        }
    }

    private static /* synthetic */ ICatenationFactory lambda$register$4(int actualInterval, IEntityTick operation, Mutable ref, Entity entity) {
        return world -> {
            ICatenationBuilder builder = ZenUtilsWorld.catenation(world);
            if (actualInterval != 0) {
                builder.sleep(actualInterval);
            }
            builder.then((world1, context) -> operation.tick(CraftTweakerMC.getIEntity((Entity)entity)));
            builder.stopWhen((world1, context) -> !entity.func_70089_S() || !entity.isAddedToWorld());
            builder.onStop((world1, context) -> {
                switch (context.getStatus()) {
                    case STOP_MANUAL: {
                        break;
                    }
                    case FINISH: {
                        ((ICatenationFactory)((Function)ref.getValue()).apply(entity)).get(world);
                    }
                    default: {
                        catenations.remove((Object)entity, (Object)context.getCatenation());
                    }
                }
            });
            Catenation catenation = builder.start();
            catenations.put((Object)entity, (Object)catenation);
            return catenation;
        };
    }
}

