/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.world;

import com.google.common.base.Predicates;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.entity.IEntityItem;
import crafttweaker.api.game.ITeam;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IFacing;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.entity.MCEntityItem;
import crafttweaker.mc1120.player.MCPlayer;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.energy.CrTEnergyStorage;
import youyihj.zenutils.api.entity.INearbyEntityList;
import youyihj.zenutils.api.item.CrTItemHandler;
import youyihj.zenutils.api.liquid.CrTLiquidHandler;
import youyihj.zenutils.api.util.CrTUUID;
import youyihj.zenutils.api.util.catenation.ICatenationBuilder;
import youyihj.zenutils.api.util.catenation.persistence.CatenationPersistenceAPI;
import youyihj.zenutils.api.util.catenation.persistence.PersistedCatenationStarter;
import youyihj.zenutils.api.world.GameRuleHelper;
import youyihj.zenutils.impl.capability.IZenWorldCapability;
import youyihj.zenutils.impl.capability.ZenWorldCapabilityHandler;
import youyihj.zenutils.impl.entity.NearbyEntityList;
import youyihj.zenutils.impl.player.FakePlayerHolder;
import youyihj.zenutils.impl.util.catenation.CatenationBuilder;

@ZenRegister
@ZenExpansion(value="crafttweaker.world.IWorld")
public class ZenUtilsWorld {
    @Nullable
    @ZenMethod
    public static IPlayer getPlayerByName(IWorld iWorld, String name) {
        return CraftTweakerMC.getIPlayer((EntityPlayer)CraftTweakerMC.getWorld((IWorld)iWorld).func_72924_a(name));
    }

    @Nullable
    @ZenMethod
    public static IPlayer getPlayerByUUID(IWorld iWorld, CrTUUID uuid) {
        return CraftTweakerMC.getIPlayer((EntityPlayer)CraftTweakerMC.getWorld((IWorld)iWorld).func_152378_a(uuid.getInternal()));
    }

    @ZenMethod
    public static List<IPlayer> getAllPlayers(IWorld iWorld) {
        return CraftTweakerMC.getWorld((IWorld)iWorld).field_73010_i.stream().map(MCPlayer::new).collect(Collectors.toList());
    }

    @ZenMethod
    public static IPlayer getClosestPlayerToEntity(IWorld iWorld, IEntity iEntity, double distance, boolean spectator) {
        return ZenUtilsWorld.getClosestPlayer(iWorld, iEntity.getPosX(), iEntity.getPosY(), iEntity.getPosZ(), distance, spectator);
    }

    @ZenMethod
    public static IPlayer getClosestPlayer(IWorld iWorld, double posX, double posY, double posZ, double distance, boolean spectator) {
        return CraftTweakerMC.getIPlayer((EntityPlayer)CraftTweakerMC.getWorld((IWorld)iWorld).func_184137_a(posX, posY, posZ, distance, spectator));
    }

    @ZenMethod
    public static List<IEntity> getEntities(IWorld iWorld) {
        return CraftTweakerMC.getWorld((IWorld)iWorld).field_72996_f.stream().map(CraftTweakerMC::getIEntity).collect(Collectors.toList());
    }

    @ZenMethod
    public static List<IEntityItem> getEntityItems(IWorld iWorld) {
        return CraftTweakerMC.getWorld((IWorld)iWorld).func_175644_a(EntityItem.class, Predicates.alwaysTrue()).stream().map(MCEntityItem::new).collect(Collectors.toList());
    }

    @ZenMethod
    public static List<IPlayer> getPlayers(IWorld iWorld) {
        return CraftTweakerMC.getWorld((IWorld)iWorld).field_73010_i.stream().map(MCPlayer::new).collect(Collectors.toList());
    }

    @ZenMethod
    public static INearbyEntityList nearbyEntities(IWorld world, IVector3d pos, double radius, @Optional IEntity exclude) {
        return new NearbyEntityList(CraftTweakerMC.getWorld((IWorld)world), pos, radius, exclude);
    }

    @ZenMethod
    public static INearbyEntityList nearbyEntities(IWorld world, IEntity entity, double radius, @Optional boolean excludeSelf) {
        return new NearbyEntityList(CraftTweakerMC.getWorld((IWorld)world), CraftTweakerMC.getIVector3d((Vec3d)new Vec3d(entity.getPosX(), entity.getPosY(), entity.getPosZ())), radius, (IEntity)(excludeSelf ? entity : null));
    }

    @ZenMethod
    public static IData getCustomWorldData(IWorld world) {
        return ZenUtilsWorld.getWorldCap(world).getData();
    }

    @ZenMethod
    public static void setCustomWorldData(IWorld world, IData data) {
        ZenUtilsWorld.getWorldCap(world).setData(data);
    }

    @ZenMethod
    public static void updateCustomWorldData(IWorld world, IData data) {
        ZenUtilsWorld.getWorldCap(world).updateData(data);
    }

    @ZenMethod
    public static IData getCustomChunkData(IWorld world, IBlockPos posToGetChunk) {
        return ZenUtilsWorld.getChunkCap(world, posToGetChunk).getData();
    }

    @ZenMethod
    public static void setCustomChunkData(IWorld world, IData data, IBlockPos posToGetChunk) {
        ZenUtilsWorld.getChunkCap(world, posToGetChunk).setData(data);
        ZenUtilsWorld.getChunk(world, posToGetChunk).func_76630_e();
    }

    @ZenMethod
    public static void updateCustomChunkData(IWorld world, IData data, IBlockPos posToGetChunk) {
        ZenUtilsWorld.getChunkCap(world, posToGetChunk).updateData(data);
        ZenUtilsWorld.getChunk(world, posToGetChunk).func_76630_e();
    }

    @ZenMethod
    public static void destroyBlock(IWorld world, IBlockPos pos, boolean dropBlock) {
        CraftTweakerMC.getWorld((IWorld)world).func_175655_b(CraftTweakerMC.getBlockPos((IBlockPos)pos), dropBlock);
    }

    @ZenMethod
    public static CrTItemHandler getItemHandler(IWorld world, IBlockPos pos, @Optional IFacing facing) {
        return java.util.Optional.ofNullable(CraftTweakerMC.getWorld((IWorld)world).func_175625_s(CraftTweakerMC.getBlockPos((IBlockPos)pos))).map(tileEntity -> {
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, CraftTweakerMC.getFacing((IFacing)facing));
            return CrTItemHandler.of(itemHandler);
        }).orElse(null);
    }

    @ZenMethod
    public static CrTLiquidHandler getLiquidHandler(IWorld world, IBlockPos pos, @Optional IFacing facing) {
        return java.util.Optional.ofNullable(CraftTweakerMC.getWorld((IWorld)world).func_175625_s(CraftTweakerMC.getBlockPos((IBlockPos)pos))).map(tileEntity -> {
            IFluidHandler fluidHandler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, CraftTweakerMC.getFacing((IFacing)facing));
            return CrTLiquidHandler.of(fluidHandler);
        }).orElse(null);
    }

    @ZenMethod
    public static CrTEnergyStorage getEnergyStorage(IWorld world, IBlockPos pos, @Optional IFacing facing) {
        return java.util.Optional.ofNullable(CraftTweakerMC.getWorld((IWorld)world).func_175625_s(CraftTweakerMC.getBlockPos((IBlockPos)pos))).map(tileEntity -> {
            IEnergyStorage energyStorage = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, CraftTweakerMC.getFacing((IFacing)facing));
            return CrTEnergyStorage.of(energyStorage);
        }).orElse(null);
    }

    @ZenMethod
    public static ICatenationBuilder catenation(IWorld world) {
        return new CatenationBuilder(world);
    }

    @ZenMethod
    public static PersistedCatenationStarter persistedCatenation(IWorld world, String catenationKey) {
        return CatenationPersistenceAPI.startPersistedCatenation(catenationKey, world);
    }

    @ZenMethod
    public static int getBlockBrightness(IWorld world, IBlockPos pos) {
        return CraftTweakerMC.getWorld((IWorld)world).func_175642_b(EnumSkyBlock.BLOCK, CraftTweakerMC.getBlockPos((IBlockPos)pos));
    }

    @ZenMethod
    public static int getSkyBrightness(IWorld world, IBlockPos pos, @Optional boolean subtracted) {
        World mcWorld = CraftTweakerMC.getWorld((IWorld)world);
        int light = mcWorld.func_175642_b(EnumSkyBlock.SKY, CraftTweakerMC.getBlockPos((IBlockPos)pos));
        return subtracted ? Math.max(0, light - mcWorld.func_175657_ab()) : light;
    }

    @ZenMethod
    public static int getBrightnessSubtracted(IWorld world, IBlockPos pos) {
        return CraftTweakerMC.getWorld((IWorld)world).func_175671_l(CraftTweakerMC.getBlockPos((IBlockPos)pos));
    }

    @ZenMethod
    @ZenGetter(value="gameRuleHelper")
    public static GameRuleHelper getGameRuleHelper(IWorld world) {
        return new GameRuleHelper(CraftTweakerMC.getWorld((IWorld)world).func_82736_K());
    }

    @ZenMethod
    @ZenGetter(value="fakePlayer")
    public static IPlayer getFakePlayer(IWorld world) {
        World mcWorld = CraftTweakerMC.getWorld((IWorld)world);
        if (mcWorld instanceof WorldServer) {
            return CraftTweakerMC.getIPlayer((EntityPlayer)FakePlayerHolder.get((WorldServer)mcWorld));
        }
        throw new IllegalStateException("Server side only.");
    }

    @ZenGetter(value="teams")
    public static List<ITeam> getTeams(IWorld world) {
        return CraftTweakerMC.getWorld((IWorld)world).func_96441_U().func_96525_g().stream().map(CraftTweakerMC::getITeam).collect(Collectors.toList());
    }

    @ZenMethod
    public static ITeam getTeam(IWorld world, String name) {
        return CraftTweakerMC.getITeam((Team)CraftTweakerMC.getWorld((IWorld)world).func_96441_U().func_96508_e(name));
    }

    @ZenMethod
    public static ITeam createTeam(IWorld world, String name) {
        return CraftTweakerMC.getITeam((Team)CraftTweakerMC.getWorld((IWorld)world).func_96441_U().func_96527_f(name));
    }

    @ZenMethod
    public static void removeTeam(IWorld world, String name) {
        Scoreboard scoreboard = CraftTweakerMC.getWorld((IWorld)world).func_96441_U();
        ScorePlayerTeam team = scoreboard.func_96508_e(name);
        if (team != null) {
            scoreboard.func_96511_d(team);
        }
    }

    private static IZenWorldCapability getWorldCap(IWorld world) {
        return (IZenWorldCapability)CraftTweakerMC.getWorld((IWorld)world).getCapability(ZenWorldCapabilityHandler.ZEN_WORLD_CAPABILITY, null);
    }

    private static IZenWorldCapability getChunkCap(IWorld world, IBlockPos posToGetChunk) {
        return (IZenWorldCapability)ZenUtilsWorld.getChunk(world, posToGetChunk).getCapability(ZenWorldCapabilityHandler.ZEN_WORLD_CAPABILITY, null);
    }

    private static Chunk getChunk(IWorld world, IBlockPos pos) {
        return CraftTweakerMC.getWorld((IWorld)world).func_175726_f(CraftTweakerMC.getBlockPos((IBlockPos)pos));
    }
}

