/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.world;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.mc1120.CraftTweaker;
import net.minecraft.command.CommandGameRule;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.GameRules;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.zenutils.GameRuleHelper")
public class GameRuleHelper {
    private final GameRules rules;

    public GameRuleHelper(GameRules gameRules) {
        this.rules = gameRules;
    }

    @ZenMethod
    public boolean getBoolean(String name) {
        return this.rules.func_82766_b(name);
    }

    @ZenMethod
    public String getString(String name) {
        return this.rules.func_82767_a(name);
    }

    @ZenMethod
    public int getInt(String name) {
        return this.rules.func_180263_c(name);
    }

    @ZenMethod
    public String[] getRules() {
        return this.rules.func_82763_b();
    }

    @ZenMethod
    public boolean hasRule(String name) {
        return this.rules.func_82765_e(name);
    }

    @ZenMethod
    public void setInt(String name, int value) {
        if (!this.rules.func_180264_a(name, GameRules.ValueType.NUMERICAL_VALUE)) {
            throw new IllegalArgumentException("GameRule " + name + " is not numerical value.");
        }
        this.rules.func_82764_b(name, Integer.toString(value));
        CommandGameRule.func_184898_a((GameRules)this.rules, (String)name, (MinecraftServer)CraftTweaker.server);
    }

    @ZenMethod
    public void setBoolean(String name, boolean value) {
        if (!this.rules.func_180264_a(name, GameRules.ValueType.BOOLEAN_VALUE)) {
            throw new IllegalArgumentException("GameRule " + name + " is not boolean value.");
        }
        this.rules.func_82764_b(name, Boolean.toString(value));
        CommandGameRule.func_184898_a((GameRules)this.rules, (String)name, (MinecraftServer)CraftTweaker.server);
    }

    @ZenMethod
    public void setString(String name, String value) {
        if (!this.rules.func_180264_a(name, GameRules.ValueType.ANY_VALUE)) {
            throw new IllegalArgumentException("GameRule " + name + " is not string value.");
        }
        this.rules.func_82764_b(name, value);
        CommandGameRule.func_184898_a((GameRules)this.rules, (String)name, (MinecraftServer)CraftTweaker.server);
    }

    @ZenMethod
    public void addGameRule(String key, String value, String type) {
        if (this.hasRule(key)) {
            return;
        }
        GameRules.ValueType valueType = GameRules.ValueType.ANY_VALUE;
        switch (type.toLowerCase()) {
            case "any": {
                break;
            }
            case "numeric": {
                valueType = GameRules.ValueType.NUMERICAL_VALUE;
                break;
            }
            case "boolean": {
                valueType = GameRules.ValueType.BOOLEAN_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid GameRule type, must be Any, Numeric or Boolean.");
            }
        }
        this.rules.func_180262_a(key, value, valueType);
    }
}

