/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util.catenation.persistence;

import crafttweaker.api.data.IData;
import java.util.Objects;
import java.util.function.Supplier;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.impl.util.catenation.persistence.ObjectHolderTypeRegistry;

public interface ICatenationObjectHolder<T> {
    public Type<T> getType();

    public IData serializeToData();

    public void deserializeFromData(IData var1);

    public void receiveObject(T var1);

    public T getValue();

    public void setValue(T var1);

    default public ValidationResult validate(Catenation catenation) {
        return this.getValue() == null ? ValidationResult.INVALID_PAUSE : ValidationResult.VALID;
    }

    default public void invalidate() {
    }

    public static enum ValidationResult {
        VALID,
        INVALID_PAUSE,
        INVALID_STOP;


        public boolean isValid() {
            return this == VALID;
        }
    }

    public static final class Key<T> {
        private final String key;
        private final Type<T> type;

        private Key(String key, Type<T> type) {
            this.key = key;
            this.type = type;
        }

        public static <T> Key<T> of(String key, Type<T> type) {
            return new Key<T>(key, type);
        }

        public String getKey() {
            return this.key;
        }

        public Type<T> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key1 = (Key)o;
            return Objects.equals(this.key, key1.key) && Objects.equals(this.type, key1.type);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.type);
        }
    }

    public static final class Type<T> {
        private final Supplier<ICatenationObjectHolder<T>> factory;
        private final Class<T> valueType;

        private Type(Supplier<ICatenationObjectHolder<T>> factory, Class<T> valueType) {
            this.factory = factory;
            this.valueType = valueType;
        }

        public static <T> Type<T> of(Supplier<ICatenationObjectHolder<T>> factory, Class<T> valueType) {
            Type<T> type = new Type<T>(factory, valueType);
            ObjectHolderTypeRegistry.register(type);
            return type;
        }

        public ICatenationObjectHolder<T> createHolder() {
            return this.factory.get();
        }

        public Class<T> getValueType() {
            return this.valueType;
        }
    }
}

