/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util.catenation;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.entity.IEntity;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IWorld;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenSetter;
import youyihj.zenutils.api.util.catenation.Catenation;
import youyihj.zenutils.api.util.catenation.CatenationStatus;
import youyihj.zenutils.api.util.catenation.IWorldFunction;
import youyihj.zenutils.api.util.catenation.persistence.BuiltinObjectHolderTypes;
import youyihj.zenutils.api.util.catenation.persistence.ICatenationObjectHolder;
import youyihj.zenutils.impl.util.catenation.persistence.CatenationPersistenceImpl;

@ZenRegister
@ZenClass(value="mods.zenutils.CatenationContext")
public class CatenationContext {
    private IData data;
    private final Catenation catenation;
    @Nullable
    private final IWorldFunction onStop;
    private CatenationStatus status = CatenationStatus.WORKING;
    private final Map<ICatenationObjectHolder.Key<?>, ICatenationObjectHolder<?>> objectHolders = new HashMap();

    public CatenationContext(Catenation catenation, @Nullable IWorldFunction onStop) {
        this.catenation = catenation;
        this.onStop = onStop;
    }

    @ZenGetter(value="data")
    @ZenMethod
    public IData getData() {
        if (this.data == null) {
            throw new IllegalStateException("Unable to call `getData` when data is null!");
        }
        return this.data;
    }

    @ZenSetter(value="data")
    @ZenMethod
    public void setData(IData data) {
        this.data = data;
    }

    @ZenMethod
    @ZenGetter
    public boolean hasData() {
        return this.data != null;
    }

    @ZenGetter(value="status")
    @ZenMethod
    public CatenationStatus getStatus() {
        return this.status;
    }

    public void setStatus(CatenationStatus status, IWorld world) {
        if (status == CatenationStatus.SERIAL) {
            CatenationPersistenceImpl.addWaitingCatenation(this.catenation);
        }
        if (this.getStatus().isRerun()) {
            this.status = status;
            if (this.getStatus().isStop() && this.onStop != null && world != null) {
                try {
                    this.onStop.apply(world, this);
                }
                catch (Exception e) {
                    CraftTweakerAPI.logError((String)"Exception occurred in onStop function", (Throwable)e);
                }
            }
        }
    }

    public void setStatus(CatenationStatus status) {
        if (!status.isStop()) {
            this.setStatus(status, this.catenation.getWorld());
        }
    }

    public Map<ICatenationObjectHolder.Key<?>, ICatenationObjectHolder<?>> getObjectHolders() {
        return this.objectHolders;
    }

    public <T> T getObject(String key, ICatenationObjectHolder.Type<T> type) {
        ICatenationObjectHolder<?> objectHolder = this.objectHolders.get(ICatenationObjectHolder.Key.of(key, type));
        if (objectHolder != null) {
            return (T)objectHolder.getValue();
        }
        throw new IllegalArgumentException("No such object key: " + key);
    }

    public void checkObjectHolders() {
        ICatenationObjectHolder.ValidationResult result = this.catenation.validateObjectHolders();
        if (result.isValid() && this.getStatus() == CatenationStatus.SERIAL) {
            this.setStatus(CatenationStatus.WORKING);
        } else if (!result.isValid() && this.getStatus() == CatenationStatus.WORKING) {
            this.setStatus(result == ICatenationObjectHolder.ValidationResult.INVALID_PAUSE ? CatenationStatus.SERIAL : CatenationStatus.STOP_INTERNAL);
        }
    }

    @ZenGetter(value="catenation")
    public Catenation getCatenation() {
        return this.catenation;
    }

    @ZenMethod
    public void stop() {
        this.catenation.stop();
    }

    @ZenMethod
    public IPlayer getPlayer(@Optional(value="player") String key) {
        return this.getObject(key, BuiltinObjectHolderTypes.PLAYER);
    }

    @ZenMethod
    public IBlockPos getPosition(@Optional(value="pos") String key) {
        return this.getObject(key, BuiltinObjectHolderTypes.POSITION);
    }

    @ZenMethod
    public IData getPersistedData(@Optional(value="data") String key) {
        return this.getObject(key, BuiltinObjectHolderTypes.DATA);
    }

    @ZenMethod
    public IEntity getEntity(@Optional(value="entity") String key) {
        return this.getObject(key, BuiltinObjectHolderTypes.ENTITY);
    }
}

