/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util;

import com.google.common.base.Functions;
import crafttweaker.annotations.ZenRegister;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import stanhebben.zenscript.annotations.IterableSimple;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;
import youyihj.zenutils.api.util.StringPredicate;

@ZenRegister
@IterableSimple(value="string")
@ZenClass(value="mods.zenutils.StringList")
public class StringList
implements Iterable<String> {
    private final List<String> inner;

    private StringList(Collection<?> list) {
        this.inner = list.stream().map(Functions.toStringFunction()).collect(Collectors.toList());
    }

    @ZenMethod
    public static StringList create(Collection<?> list) {
        return new StringList(list);
    }

    @ZenMethod
    public static StringList create(Object[] objects) {
        return new StringList(Arrays.asList(objects));
    }

    @ZenMethod
    public static StringList empty() {
        return new StringList(Collections.emptyList());
    }

    @ZenMethod
    public static StringList singletonList(Object object) {
        return new StringList(Collections.singletonList(object));
    }

    @Override
    @Nonnull
    public Iterator<String> iterator() {
        return this.inner.iterator();
    }

    @ZenMethod
    @ZenOperator(value=OperatorType.INDEXGET)
    public String get(int index) {
        return this.inner.get(index);
    }

    @ZenMethod
    @ZenOperator(value=OperatorType.INDEXSET)
    public String set(int index, Object obj) {
        return this.inner.set(index, String.valueOf(obj));
    }

    @ZenMethod
    public boolean add(Object obj) {
        return this.inner.add(String.valueOf(obj));
    }

    @ZenMethod
    public boolean remove(Object obj) {
        return this.inner.remove(String.valueOf(obj));
    }

    @ZenMethod
    public void clear() {
        this.inner.clear();
    }

    @ZenMethod
    public boolean removeIf(StringPredicate predicate) {
        return this.inner.removeIf(predicate);
    }

    @ZenMethod
    @ZenOperator(value=OperatorType.CONTAINS)
    public boolean contains(Object obj) {
        return this.inner.contains(String.valueOf(obj));
    }

    @ZenMethod
    public boolean add(String s) {
        return this.inner.add(s);
    }

    @ZenMethod
    public void insert(int index, String s) {
        this.inner.add(index, s);
    }

    @ZenMethod
    public boolean remove(String s) {
        return this.inner.remove(s);
    }

    @ZenMethod
    @ZenOperator(value=OperatorType.CONTAINS)
    public boolean contains(String s) {
        return this.inner.contains(s);
    }

    @ZenGetter
    @ZenMethod
    public int size() {
        return this.inner.size();
    }

    @ZenMethod
    public int indexOf(String s) {
        return this.inner.indexOf(s);
    }

    @ZenMethod
    public int lastIndexOf(String s) {
        return this.inner.lastIndexOf(s);
    }

    @ZenMethod
    public StringList subList(int fromIndex, int toIndex) {
        return StringList.create(this.inner.subList(fromIndex, toIndex));
    }

    @ZenMethod
    public void shuffle() {
        Collections.shuffle(this.inner);
    }

    @ZenMethod
    public String[] toArray() {
        return this.inner.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        Iterator<String> iterator = this.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.append("]").toString();
    }

    @ZenMethod
    public List<String> getInner() {
        return this.inner;
    }
}

