/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.util;

import crafttweaker.annotations.ZenRegister;
import java.util.Objects;
import java.util.UUID;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenCaster;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenRegister
@ZenClass(value="mods.zenutils.UUID")
public class CrTUUID {
    private final UUID uuid;

    public CrTUUID(UUID uuid) {
        this.uuid = uuid;
    }

    @ZenMethod
    public long getMostSignificantBits() {
        return this.uuid.getMostSignificantBits();
    }

    @ZenMethod
    public long getLeastSignificantBits() {
        return this.uuid.getLeastSignificantBits();
    }

    @ZenMethod
    @ZenCaster
    public String asString() {
        return this.uuid.toString();
    }

    @ZenMethod
    public static CrTUUID randomUUID() {
        return new CrTUUID(UUID.randomUUID());
    }

    @ZenMethod
    public static CrTUUID fromString(String name) {
        return new CrTUUID(UUID.fromString(name));
    }

    @ZenMethod
    public static CrTUUID fromSignificantBits(long most, long least) {
        return new CrTUUID(new UUID(most, least));
    }

    @ZenOperator(value=OperatorType.COMPARE)
    public int compareTo(CrTUUID other) {
        return this.uuid.compareTo(other.uuid);
    }

    public UUID getInternal() {
        return this.uuid;
    }

    @ZenOperator(value=OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrTUUID crTUUID = (CrTUUID)o;
        return Objects.equals(this.uuid, crTUUID.uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }
}

