/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.logger;

import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import youyihj.zenutils.api.logger.ILogFilter;
import youyihj.zenutils.api.logger.LogLevel;
import youyihj.zenutils.api.logger.ScriptPosition;

public class ScriptSuppressLogFilter
implements ILogFilter {
    private final String scriptName;
    private final Set<LogLevel> suppressLevels;

    public ScriptSuppressLogFilter(String scriptName, Set<LogLevel> suppressLevels) {
        this.scriptName = scriptName;
        this.suppressLevels = suppressLevels;
    }

    @Override
    public boolean isBlock(String message, LogLevel logLevel, @Nullable ScriptPosition scriptPosition) {
        return scriptPosition != null && this.scriptName.equals(scriptPosition.getFileName()) && this.suppressLevels.contains((Object)logLevel);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptSuppressLogFilter that = (ScriptSuppressLogFilter)o;
        return Objects.equals(this.scriptName, that.scriptName) && Objects.equals(this.suppressLevels, that.suppressLevels);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.scriptName, this.suppressLevels);
    }
}

