/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.item;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenMethod;
import youyihj.zenutils.api.item.ITooltipModifier;
import youyihj.zenutils.api.reload.ScriptReloadEvent;
import youyihj.zenutils.api.util.StringList;
import youyihj.zenutils.impl.util.TotallyImmutableItemStack;

@ZenRegister
@ZenExpansion(value="crafttweaker.item.IIngredient")
@Mod.EventBusSubscriber
public class ItemTooltipModification {
    private static final Map<IIngredient, ITooltipModifier> MODIFIERS = new LinkedHashMap<IIngredient, ITooltipModifier>();

    @ZenMethod
    public static void modifyTooltip(IIngredient ingredient, ITooltipModifier modifier) {
        MODIFIERS.put(ingredient, modifier);
    }

    @SubscribeEvent
    public static void onReloadPre(ScriptReloadEvent.Pre event) {
        MODIFIERS.clear();
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class TooltipEventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onItemTooltip(ItemTooltipEvent event) {
            TotallyImmutableItemStack item = null;
            Iterable tooltip = null;
            boolean pressed = false;
            for (Map.Entry entry : MODIFIERS.entrySet()) {
                if (event.getItemStack().func_190926_b() || !((IIngredient)entry.getKey()).matches(CraftTweakerMC.getIItemStackForMatching((ItemStack)event.getItemStack()))) continue;
                if (tooltip == null) {
                    tooltip = StringList.create(event.getToolTip());
                    item = new TotallyImmutableItemStack(event.getItemStack());
                    pressed = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                }
                ((ITooltipModifier)entry.getValue()).apply((IItemStack)item, (StringList)tooltip, pressed, event.getFlags().func_194127_a());
            }
            if (tooltip != null) {
                event.getToolTip().clear();
                tooltip.forEach(event.getToolTip()::add);
            }
        }
    }
}

