/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.ftbq;

import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.text.expand.ExpandTextComponent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenOperator;

@ZenRegister
@ZenClass(value="mods.zenutils.ftbq.QuestObjectBase")
@ModOnly(value="ftbquests")
public class CTQuestObjectBase {
    public final QuestObjectBase object;

    public CTQuestObjectBase(QuestObjectBase object) {
        this.object = object;
    }

    @ZenGetter(value="parentID")
    public int getParentID() {
        return this.object.getParentID();
    }

    @ZenGetter(value="data")
    public IData getData() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.object.writeData(nbt);
        return CraftTweakerMC.getIData((NBTBase)nbt);
    }

    @ZenGetter(value="title")
    @Deprecated
    public String getTitle() {
        CraftTweakerAPI.logWarning((String)"Use titleText getter instead. The method doesn't work on dedicated server.");
        return this.object.getTitle();
    }

    @ZenGetter(value="titleText")
    public crafttweaker.api.text.ITextComponent getTitleText() {
        String textTitle = this.object.loadText().getString("title");
        if (!textTitle.isEmpty()) {
            return ExpandTextComponent.fromString((String)textTitle);
        }
        if (this.object.title.isEmpty()) {
            throw new IllegalArgumentException(String.format("Quest object %08x doesn't have an explicit title", this.getID()));
        }
        return CTQuestObjectBase.serverAvailableText(this.object.title);
    }

    @ZenGetter(value="id")
    public int getID() {
        return this.object.id;
    }

    @ZenGetter(value="icon")
    public IItemStack getIcon() {
        return CraftTweakerMC.getIItemStack((ItemStack)this.object.icon);
    }

    @ZenGetter(value="codeString")
    public String getCodeString() {
        return this.object.getCodeString();
    }

    @ZenGetter(value="type")
    public String getType() {
        return this.object.getObjectType().name();
    }

    @ZenGetter(value="tags")
    public String[] getTags() {
        return this.object.getTags().toArray(new String[0]);
    }

    @ZenMethod
    public boolean hasTag(String tag) {
        return this.object.hasTag(tag);
    }

    @ZenOperator(value=OperatorType.EQUALS)
    public boolean equals(CTQuestObjectBase others) {
        if (others == null) {
            return false;
        }
        return this.object.equals((Object)others.object);
    }

    protected static crafttweaker.api.text.ITextComponent serverAvailableText(String ftbqUnlocalizedText) {
        TextComponentString text = new TextComponentString("");
        ftbqUnlocalizedText = TextFormatting.func_110646_a((String)ftbqUnlocalizedText);
        boolean inTranslation = false;
        StringBuilder currentSnippet = new StringBuilder();
        if (ftbqUnlocalizedText != null) {
            for (int i = 0; i < ftbqUnlocalizedText.length(); ++i) {
                char c = ftbqUnlocalizedText.charAt(i);
                if (c == '{' && !inTranslation) {
                    inTranslation = true;
                    if (currentSnippet.length() == 0) continue;
                    text.func_150257_a((ITextComponent)new TextComponentString(currentSnippet.toString()));
                    currentSnippet = new StringBuilder();
                    continue;
                }
                if (c == '}' && inTranslation) {
                    inTranslation = false;
                    if (currentSnippet.length() == 0) continue;
                    text.func_150257_a((ITextComponent)new TextComponentTranslation(currentSnippet.toString(), new Object[0]));
                    currentSnippet = new StringBuilder();
                    continue;
                }
                currentSnippet.append(c);
            }
            if (currentSnippet.length() != 0) {
                text.func_150257_a((ITextComponent)new TextComponentString(currentSnippet.toString()));
            }
        }
        return CraftTweakerMC.getITextComponent((ITextComponent)text);
    }
}

