/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.cotx.tile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import crafttweaker.CraftTweakerAPI;
import java.util.Map;
import youyihj.zenutils.api.cotx.function.ITileEntityTick;
import youyihj.zenutils.api.cotx.tile.TileEntityRepresentation;

public final class TileEntityManager {
    private static final Map<Integer, ITileEntityTick> TICK_FUNCTIONS = Maps.newHashMap();

    public static void registerTileEntity(TileEntityRepresentation tileEntityRepresentation) {
        int id = tileEntityRepresentation.getId();
        if (TICK_FUNCTIONS.containsKey(id)) {
            CraftTweakerAPI.logError((String)("Tile Entity ID: " + id + " has been used!"));
            return;
        }
        TileEntityManager.putTickFunction(id, tileEntityRepresentation.onTick);
    }

    public static ITileEntityTick getTickFunction(int id) {
        return TICK_FUNCTIONS.getOrDefault(id, (tileEntity, world, pos) -> {});
    }

    public static void putTickFunction(int id, ITileEntityTick tileEntityTick) {
        Preconditions.checkArgument((id != -1 ? 1 : 0) != 0, (Object)"id -1 is reserved");
        TICK_FUNCTIONS.put(id, tileEntityTick);
    }
}

