/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.cotx.brackets;

import com.teamacronymcoders.base.registrysystem.BlockRegistry;
import com.teamacronymcoders.contenttweaker.ContentTweaker;
import com.teamacronymcoders.contenttweaker.modules.vanilla.blocks.BlockContent;
import com.teamacronymcoders.contenttweaker.modules.vanilla.blocks.BlockRepresentation;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.zenscript.IBracketHandler;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import youyihj.zenutils.api.cotx.annotation.ExpandContentTweakerEntry;
import youyihj.zenutils.api.cotx.brackets.LateGetContentLookup;
import youyihj.zenutils.api.zenscript.SidedZenRegister;
import youyihj.zenutils.impl.util.ReflectUtils;
import youyihj.zenutils.impl.zenscript.ExpressionCallStaticThenCastWithStringArg;

@SidedZenRegister(modDeps={"contenttweaker"})
@BracketHandler(priority=100)
public class BracketHandlerCoTBlock
implements IBracketHandler {
    private static final IJavaMethod representationGetter = CraftTweakerAPI.getJavaMethod(BracketHandlerCoTBlock.class, (String)"getBlockRepresentation", (Class[])new Class[]{String.class});

    public static BlockRepresentation getBlockRepresentation(String name) {
        Block block = BracketHandlerCoTBlock.getBlock(name);
        if (block instanceof BlockContent) {
            try {
                if (block.getClass() == BlockContent.class) {
                    return (BlockRepresentation)ReflectUtils.removePrivate(BlockContent.class, "blockRepresentation").get(block);
                }
                if (block.getClass().isAnnotationPresent(ExpandContentTweakerEntry.class)) {
                    for (Method method : block.getClass().getMethods()) {
                        if (!method.isAnnotationPresent(ExpandContentTweakerEntry.RepresentationGetter.class)) continue;
                        return (BlockRepresentation)method.invoke((Object)block, new Object[0]);
                    }
                }
            }
            catch (ClassCastException | ReflectiveOperationException e) {
                CraftTweakerAPI.logError(null, (Throwable)e);
            }
        }
        return null;
    }

    private static Block getBlock(String name) {
        Block block = (Block)((BlockRegistry)ContentTweaker.instance.getRegistry(BlockRegistry.class, "BLOCK")).get(new ResourceLocation("contenttweaker", name));
        if (block instanceof BlockContent) {
            LateGetContentLookup.addBlock((BlockContent)block);
        }
        return block;
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() > 2 && tokens.get(0).getValue().equals("cotBlock") && tokens.get(1).getValue().equals(":")) {
            return this.find(environment, tokens);
        }
        return null;
    }

    private IZenSymbol find(IEnvironmentGlobal environment, List<Token> tokens) {
        String name = tokens.get(2).getValue();
        BlockRepresentation blockRepresentation = BracketHandlerCoTBlock.getBlockRepresentation(name);
        if (blockRepresentation == null) {
            return null;
        }
        return position -> new ExpressionCallStaticThenCastWithStringArg(position, environment, representationGetter, blockRepresentation.getClass(), name);
    }

    public String getRegexMatchingString() {
        return "cotBlock:.*";
    }

    public Class<?> getReturnedClass() {
        return BlockRepresentation.class;
    }
}

