/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils.api.cotx.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.GeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.IGeneratedModel;
import com.teamacronymcoders.base.client.models.generator.generatedmodel.ModelType;
import com.teamacronymcoders.base.util.files.templates.TemplateFile;
import com.teamacronymcoders.base.util.files.templates.TemplateManager;
import com.teamacronymcoders.contenttweaker.api.ctobjects.resourcelocation.CTResourceLocation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import youyihj.zenutils.api.cotx.annotation.ExpandContentTweakerEntry;
import youyihj.zenutils.api.cotx.block.DirectionalBlockRepresentation;
import youyihj.zenutils.api.cotx.block.ExpandBlockContent;
import youyihj.zenutils.api.cotx.block.OmniDirectionalBlockContent;

@ExpandContentTweakerEntry
public abstract class DirectionalBlockContent
extends ExpandBlockContent {
    public static final IProperty<DirectionalBlockRepresentation.PlaneRotation> PLANE_ROTATION_PROPERTY = PropertyEnum.func_177709_a((String)"plane_rot", DirectionalBlockRepresentation.PlaneRotation.class);

    protected DirectionalBlockContent(DirectionalBlockRepresentation blockRepresentation) {
        super(blockRepresentation);
    }

    public static DirectionalBlockContent create(final DirectionalBlockRepresentation blockRepresentation) {
        if (blockRepresentation.isPlaneRotatable() && blockRepresentation.getDirections() == DirectionalBlockRepresentation.Directions.ALL) {
            return new OmniDirectionalBlockContent(blockRepresentation){

                @Override
                public DirectionalBlockRepresentation getExpandBlockRepresentation() {
                    return blockRepresentation;
                }
            };
        }
        return new DirectionalBlockContent(blockRepresentation){

            @Override
            protected BlockStateContainer func_180661_e() {
                if (!blockRepresentation.isPlaneRotatable()) {
                    return new BlockStateContainer((Block)this, new IProperty[]{this.getDirections().getBlockProperty()});
                }
                return new BlockStateContainer((Block)this, new IProperty[]{this.getDirections().getBlockProperty(), PLANE_ROTATION_PROPERTY});
            }

            @Override
            public DirectionalBlockRepresentation getExpandBlockRepresentation() {
                return blockRepresentation;
            }
        };
    }

    public DirectionalBlockRepresentation.Directions getDirections() {
        return this.getExpandBlockRepresentation().getDirections();
    }

    protected abstract BlockStateContainer func_180661_e();

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        if (this.getDirections() != DirectionalBlockRepresentation.Directions.VERTICAL) {
            return state.func_177226_a(this.getDirections().getBlockProperty(), (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b(this.getDirections().getBlockProperty())));
        }
        return super.func_185471_a(state, mirrorIn);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        if (this.getDirections() != DirectionalBlockRepresentation.Directions.VERTICAL) {
            return state.func_177226_a(this.getDirections().getBlockProperty(), (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b(this.getDirections().getBlockProperty())));
        }
        return super.func_185499_a(state, rot);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        if (!this.getExpandBlockRepresentation().isPlaneRotatable()) {
            return super.rotateBlock(world, pos, axis);
        }
        IBlockState state = world.func_180495_p(pos);
        if (axis == state.func_177229_b(this.getDirections().getBlockProperty())) {
            world.func_175656_a(pos, state.func_177226_a(PLANE_ROTATION_PROPERTY, (Comparable)((Object)((DirectionalBlockRepresentation.PlaneRotation)((Object)state.func_177229_b(PLANE_ROTATION_PROPERTY))).rotateClockWise90())));
            return true;
        }
        return super.rotateBlock(world, pos, axis);
    }

    public int func_176201_c(IBlockState state) {
        return this.getDirections().toMeta(state, this.getExpandBlockRepresentation().isPlaneRotatable());
    }

    public IBlockState func_176203_a(int meta) {
        return this.getDirections().toState(meta, this.func_176223_P(), this.getExpandBlockRepresentation().isPlaneRotatable());
    }

    @Nullable
    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        return this.getDirections().getValidFacings();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing blockFacing;
        IProperty<EnumFacing> property = this.getDirections().getBlockProperty();
        Vec3d lookVec = placer.func_70040_Z();
        switch (this.getDirections()) {
            case ALL: {
                blockFacing = EnumFacing.func_176737_a((float)((float)lookVec.field_72450_a), (float)((float)lookVec.field_72448_b), (float)((float)lookVec.field_72449_c));
                break;
            }
            case HORIZONTAL: {
                blockFacing = placer.func_174811_aO();
                break;
            }
            case VERTICAL: {
                blockFacing = lookVec.field_72448_b > 0.0 ? EnumFacing.UP : EnumFacing.DOWN;
                break;
            }
            default: {
                return this.func_176223_P();
            }
        }
        if (this.getExpandBlockRepresentation().isPlacingOpposite()) {
            blockFacing = blockFacing.func_176734_d();
        }
        return this.func_176223_P().func_177226_a(property, (Comparable)blockFacing);
    }

    public List<IGeneratedModel> getGeneratedModels() {
        ArrayList models = Lists.newArrayList();
        String templateFileName = (this.getExpandBlockRepresentation().isPlaneRotatable() ? "plane_rotatable_" : "") + this.getDirections().name().toLowerCase(Locale.ENGLISH) + "_directional_block";
        this.getResourceLocations(Lists.newArrayList()).forEach(resourceLocation -> {
            TemplateFile templateFile = TemplateManager.getTemplateFile((ResourceLocation)new ResourceLocation("zenutils", templateFileName));
            HashMap replacements = Maps.newHashMap();
            replacements.put("texture", Optional.ofNullable(this.getExpandBlockRepresentation().getTextureLocation()).map(CTResourceLocation::getInternal).map(ResourceLocation::toString).orElseGet(() -> new ResourceLocation(resourceLocation.func_110624_b(), "blocks/" + resourceLocation.func_110623_a()).toString()));
            templateFile.replaceContents((Map)replacements);
            models.add(new GeneratedModel(resourceLocation.func_110623_a(), ModelType.BLOCKSTATE, templateFile.getFileContents()));
        });
        return models;
    }

    @Override
    public abstract DirectionalBlockRepresentation getExpandBlockRepresentation();
}

