/*
 * Decompiled with CFR 0.152.
 */
package youyihj.zenutils;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.api.player.IPlayer;
import crafttweaker.mc1120.CraftTweaker;
import crafttweaker.mc1120.commands.CTChatCommand;
import crafttweaker.mc1120.commands.CraftTweakerCommand;
import crafttweaker.mc1120.player.expand.ExpandPlayer;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.command.CommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;
import youyihj.zenutils.api.command.ZenCommandRegisterAction;
import youyihj.zenutils.api.cotx.brackets.LateGetContentLookup;
import youyihj.zenutils.api.ftbq.FTBQEventManager;
import youyihj.zenutils.api.zenscript.SidedZenRegister;
import youyihj.zenutils.impl.capability.ZenWorldCapabilityHandler;
import youyihj.zenutils.impl.command.CleanLogCommand;
import youyihj.zenutils.impl.command.StatCommand;
import youyihj.zenutils.impl.network.PlayerScriptValidation;
import youyihj.zenutils.impl.network.ZenUtilsNetworkHandler;
import youyihj.zenutils.impl.player.IStatFormatterAdapter;
import youyihj.zenutils.impl.player.PlayerInteractionSimulation;
import youyihj.zenutils.impl.reload.ReloadCommand;
import youyihj.zenutils.impl.runtime.ScriptStatus;
import youyihj.zenutils.impl.runtime.ZenUtilsLogger;
import youyihj.zenutils.impl.runtime.ZenUtilsTweaker;
import youyihj.zenutils.impl.util.InternalUtils;

@Mod(modid="zenutils", name="ZenUtils", version="1.21.9", dependencies="required-after:crafttweaker;required-after:mixinbooter@[8.0,);required-after:configanytime;before:contenttweaker;after:ftbquests;", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class ZenUtils {
    public static Logger forgeLogger;
    public static ZenUtilsLogger crafttweakerLogger;
    public static ZenUtilsTweaker tweaker;
    public static ASMDataTable asmDataTable;
    @SidedProxy(clientSide="youyihj.zenutils.impl.player.IStatFormatterAdapter$Client", serverSide="youyihj.zenutils.impl.player.IStatFormatterAdapter$Server")
    public static IStatFormatterAdapter statFormatterAdapter;

    @Mod.EventHandler
    public static void onConstruct(FMLConstructionEvent event) {
        InternalUtils.checkCraftTweakerVersion("4.1.20.692", () -> InternalUtils.hasMethod(ExpandPlayer.class, "isSpectator", IPlayer.class));
        try {
            crafttweakerLogger = (ZenUtilsLogger)CraftTweakerAPI.getLogger();
            tweaker = (ZenUtilsTweaker)CraftTweakerAPI.tweaker;
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("CraftTweaker ITweaker or Logger is not redirected. A mixin config is failed. please report to the mod author!");
        }
        if (Loader.isModLoaded((String)"ftbquests")) {
            MinecraftForge.EVENT_BUS.register(FTBQEventManager.Handler.class);
        }
    }

    @Mod.EventHandler
    public static void onPreInit(FMLPreInitializationEvent event) {
        CraftTweakerAPI.logInfo((String)"Hey! Here is ZenUtils.");
        ZenWorldCapabilityHandler.register();
        PlayerInteractionSimulation.registerNetworkMessage();
        asmDataTable = event.getAsmData();
        forgeLogger = event.getModLog();
        ZenUtils.readSidedZenRegisters(event.getSide());
        try {
            InternalUtils.scanAllEventLists();
        }
        catch (NoSuchFieldException e) {
            forgeLogger.error("failed to scan all event lists", (Throwable)e);
        }
    }

    @Mod.EventHandler
    public static void onServerStarting(FMLServerStartingEvent event) {
        CTChatCommand.registerCommand((CraftTweakerCommand)new ReloadCommand());
        CTChatCommand.registerCommand((CraftTweakerCommand)new StatCommand());
        CTChatCommand.registerCommand((CraftTweakerCommand)new CleanLogCommand());
        if (ZenUtilsNetworkHandler.INSTANCE.shouldValidateScripts(event.getServer())) {
            MinecraftForge.EVENT_BUS.register(PlayerScriptValidation.ServerEventHandler.class);
        }
        ZenCommandRegisterAction.ApplyLogic.INSTANCE.init((CommandHandler)event.getServer().field_71321_q);
        if (InternalUtils.isContentTweakerInstalled()) {
            LateGetContentLookup.refreshFields();
            LateGetContentLookup.clear();
        }
    }

    @Mod.EventHandler
    public static void onServerStop(FMLServerStoppedEvent event) {
        ZenCommandRegisterAction.ApplyLogic.INSTANCE.clean();
    }

    @Mod.EventHandler
    public static void onServerStarted(FMLServerStartedEvent event) {
        CraftTweakerAPI.tweaker.getActions().clear();
        InternalUtils.setScriptStatus(ScriptStatus.STARTED);
    }

    private static void readSidedZenRegisters(Side side) {
        asmDataTable.getAll(SidedZenRegister.class.getCanonicalName()).forEach(arg_0 -> ZenUtils.lambda$readSidedZenRegisters$1(side, arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$readSidedZenRegisters$1(Side side, ASMDataTable.ASMData data) {
        annotationInfo = data.getAnnotationInfo();
        modDeps = (List)annotationInfo.get("modDeps");
        sides = (List)annotationInfo.get("value");
        v0 = modSatisfied = modDeps == null || modDeps.stream().allMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isModLoaded(java.lang.String ), (Ljava/lang/String;)Z)()) != false;
        if (sides == null) ** GOTO lbl-1000
        if (sides.stream().map((Function<ModAnnotation.EnumHolder, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Lnet/minecraftforge/fml/common/discovery/asm/ModAnnotation$EnumHolder;)Ljava/lang/String;)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)side.name()))) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else {
            v1 = sideSatisfied = false;
        }
        if (modSatisfied && sideSatisfied) {
            try {
                CraftTweakerAPI.registerClass(Class.forName(data.getClassName(), false, CraftTweaker.class.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                CraftTweaker.LOG.catching((Throwable)e);
            }
        }
    }
}

