/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import zone.rong.mixinbooter.ILateMixinLoader;

public class LateMixinLoader
implements ILateMixinLoader {
    public List<String> getMixinConfigs() {
        return Arrays.asList("soundphysics.gliby.mixin.json", "soundphysics.glibysrc.mixin.json", "soundphysics.comp.mixin.json", "soundphysics.umc.mixin.json", "soundphysics.midnight.mixin.json", "soundphysics.ic2c.mixin.json", "soundphysics.ic2exp.mixin.json", "soundphysics.enhancedvisuals.mixin.json");
    }

    static boolean isIC2Classic() {
        if (Loader.isModLoaded((String)"ic2")) {
            Map mods = Loader.instance().getIndexedModList();
            String version = ((ModContainer)mods.get("ic2")).getVersion();
            return !version.endsWith("ex112");
        }
        return false;
    }

    public boolean shouldMixinConfigQueue(String mixinConfig) {
        switch (mixinConfig) {
            case "soundphysics.gliby.mixin.json": {
                return Loader.isModLoaded((String)"gvc") && Config.glibyVCPatching;
            }
            case "soundphysics.glibysrc.mixin.json": {
                return Loader.isModLoaded((String)"gvc") && Config.glibyVCSrcPatching;
            }
            case "soundphysics.comp.mixin.json": {
                return Loader.isModLoaded((String)"computronics") && Config.computronicsPatching;
            }
            case "soundphysics.umc.mixin.json": {
                return Loader.isModLoaded((String)"universalmodcore") && Config.irPatching;
            }
            case "soundphysics.midnight.mixin.json": {
                return Loader.isModLoaded((String)"midnight") && Config.midnightPatching;
            }
            case "soundphysics.enhancedvisuals.mixin.json": {
                return Loader.isModLoaded((String)"enhancedvisuals") && Config.evPatching;
            }
            case "soundphysics.ic2c.mixin.json": {
                return Loader.isModLoaded((String)"ic2") && Config.ic2Patching && LateMixinLoader.isIC2Classic();
            }
            case "soundphysics.ic2exp.mixin.json": {
                return Loader.isModLoaded((String)"ic2") && Config.ic2Patching && !LateMixinLoader.isIC2Classic();
            }
        }
        return super.shouldMixinConfigQueue(mixinConfig);
    }
}

