/*
 * Decompiled with CFR 0.152.
 */
package mcjty.fxcontrol.compat;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostChunkGenerator;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCities;
import mcjty.tools.rules.IEventQuery;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class LostCitySupport {
    private static ILostCities lostCities;

    public static void register() {
        FMLInterModComms.sendFunctionMessage((String)"lostcities", (String)"getLostCities", (String)"mcjty.fxcontrol.compat.LostCitySupport$GetLostCities");
    }

    public static <T> boolean isCity(IEventQuery<T> query, T event) {
        World world = query.getWorld(event);
        if (world.field_72995_K) {
            return false;
        }
        ILostChunkGenerator generator = lostCities.getLostGenerator(world.field_73011_w.getDimension());
        if (generator != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = generator.getChunkInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunkInfo.isCity();
        }
        return false;
    }

    public static <T> boolean isStreet(IEventQuery<T> query, T event) {
        World world = query.getWorld(event);
        if (world.field_72995_K) {
            return false;
        }
        ILostChunkGenerator generator = lostCities.getLostGenerator(world.field_73011_w.getDimension());
        if (generator != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = generator.getChunkInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunkInfo.isCity() && chunkInfo.getBuildingType() == null;
        }
        return false;
    }

    public static <T> boolean inSphere(IEventQuery<T> query, T event) {
        World world = query.getWorld(event);
        if (world.field_72995_K) {
            return false;
        }
        ILostChunkGenerator generator = lostCities.getLostGenerator(world.field_73011_w.getDimension());
        if (generator != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = generator.getChunkInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunkInfo.getSphere() != null;
        }
        return false;
    }

    public static <T> boolean isBuilding(IEventQuery<T> query, T event) {
        World world = query.getWorld(event);
        if (world.field_72995_K) {
            return false;
        }
        ILostChunkGenerator generator = lostCities.getLostGenerator(world.field_73011_w.getDimension());
        if (generator != null) {
            BlockPos pos = query.getPos(event);
            ILostChunkInfo chunkInfo = generator.getChunkInfo(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunkInfo.isCity() && chunkInfo.getBuildingType() != null;
        }
        return false;
    }

    public static class GetLostCities
    implements Function<ILostCities, Void> {
        @Override
        @Nullable
        public Void apply(ILostCities lc) {
            lostCities = lc;
            return null;
        }
    }
}

