/*
 * Decompiled with CFR 0.152.
 */
package net.goldelf123.salt_lamps.blocks;

import java.util.ArrayList;
import java.util.List;
import net.goldelf123.salt_lamps.Config;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntitySaltLamp
extends TileEntity
implements ITickable {
    protected List<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
    protected int ticksLeft = 0;
    protected long timeSinceStart = 0L;

    public void onLoad() {
        this.timeSinceStart = this.field_145850_b.func_82737_E();
        if (Config.enableDiffusion) {
            this.diffuseEffects();
        }
    }

    public void func_73660_a() {
        if ((this.field_145850_b.func_82737_E() - this.timeSinceStart) % 60L == 0L && Config.enableDiffusion) {
            this.diffuseEffects();
        }
        if (this.ticksLeft > 0 && Config.enableTimeLimit) {
            --this.ticksLeft;
            if (this.ticksLeft == 0) {
                this.clearEffects();
            }
        }
    }

    public void clearEffects() {
        this.potionEffects.clear();
        this.ticksLeft = 0;
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.func_70296_d();
    }

    public void setEffects(List<PotionEffect> potionsIn) {
        this.potionEffects = potionsIn;
        int minTime = Integer.MAX_VALUE;
        for (PotionEffect potionIn : potionsIn) {
            int potionDuration = potionIn.func_76459_b();
            if (potionDuration >= minTime) continue;
            minTime = potionDuration;
        }
        this.ticksLeft = minTime;
        if (this.ticksLeft < Config.minimumDuration) {
            this.ticksLeft = Config.minimumDuration * 20;
        }
        this.ticksLeft *= Config.timeMultiplier;
        this.timeSinceStart = this.field_145850_b.func_82737_E();
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        this.func_70296_d();
    }

    public void diffuseEffects() {
        if (!this.field_145850_b.field_72995_K && !this.potionEffects.isEmpty() && this.ticksLeft > 0) {
            int posX = this.field_174879_c.func_177958_n();
            int posY = this.field_174879_c.func_177956_o();
            int posZ = this.field_174879_c.func_177952_p();
            int effectRadius = Config.areaOfEffect;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)posX, (double)posY, (double)posZ, (double)(posX + 1), (double)(posY + 1), (double)(posZ + 1)).func_186662_g((double)effectRadius);
            List listPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, axisalignedbb);
            for (EntityPlayer entityPlayer : listPlayers) {
                for (int i = 0; i < this.potionEffects.size(); ++i) {
                    if (!Config.allowNegativePlayerEffects && !this.potionEffects.get(i).func_188419_a().func_188408_i()) continue;
                    if (this.potionEffects.get(i).func_188419_a().func_76403_b()) {
                        this.potionEffects.get(i).func_188419_a().func_76394_a((EntityLivingBase)entityPlayer, this.potionEffects.get(i).func_76458_c());
                        continue;
                    }
                    entityPlayer.func_70690_d(new PotionEffect(this.potionEffects.get(i).func_188419_a(), 100, this.potionEffects.get(i).func_76458_c(), true, true));
                }
            }
        }
    }

    public boolean isDiffusing() {
        return this.ticksLeft > 0 && !this.potionEffects.isEmpty();
    }

    public List<PotionEffect> getEffects() {
        return this.potionEffects;
    }

    public int getParticleColor() {
        return PotionUtils.func_185181_a(this.potionEffects);
    }

    public int getTicksLeft() {
        return this.ticksLeft;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.potionEffects.clear();
        super.func_145839_a(compound);
        int numPotionEffects = compound.func_74762_e("NumPotionEffects");
        for (int i = 0; i < numPotionEffects; ++i) {
            PotionEffect tempPotionEffect = new PotionEffect(Potion.func_188412_a((int)compound.func_74771_c("PotionId" + i)), 0, (int)compound.func_74771_c("PotionAmplifier" + i));
            this.potionEffects.add(tempPotionEffect);
        }
        this.ticksLeft = compound.func_74762_e("TicksLeft");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("NumPotionEffects", this.potionEffects.size());
        for (int i = 0; i < this.potionEffects.size(); ++i) {
            compound.func_74774_a("PotionId" + i, (byte)Potion.func_188409_a((Potion)this.potionEffects.get(i).func_188419_a()));
            compound.func_74774_a("PotionAmplifier" + i, (byte)this.potionEffects.get(i).func_76458_c());
        }
        compound.func_74768_a("TicksLeft", this.ticksLeft);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }
}

