/*
 * Decompiled with CFR 0.152.
 */
package net.goldelf123.salt_lamps.blocks;

import java.util.Random;
import net.goldelf123.salt_lamps.Config;
import net.goldelf123.salt_lamps.blocks.TileEntitySaltLamp;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSaltLamp
extends Block
implements ITileEntityProvider {
    private String blockName = "";
    protected boolean wasLampExtinguished = false;

    public BlockSaltLamp(String nameIn) {
        super(Material.field_151592_s);
        this.func_149663_c("salt_lamps." + nameIn);
        this.setRegistryName(nameIn);
        this.func_149715_a(0.75f);
        this.func_149711_c(1.0f);
        this.func_149752_b(3.0f);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149675_a(true);
        this.blockName = nameIn;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.625, 0.6875);
    }

    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K || !Config.enableDiffusion) {
            TileEntity tileentity;
            if ((playerIn.field_71071_by.func_70448_g().func_77973_b() instanceof ItemPotion || playerIn.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSplashPotion || playerIn.field_71071_by.func_70448_g().func_77973_b() instanceof ItemLingeringPotion) && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntitySaltLamp && !playerIn.field_71071_by.func_70448_g().func_77973_b().func_77636_d(playerIn.field_71071_by.func_70448_g()) && ((TileEntitySaltLamp)tileentity).isDiffusing()) {
                for (int i = 0; i < 5; ++i) {
                    double d0 = (double)pos.func_177958_n() + worldIn.field_73012_v.nextDouble() * 0.6 + 0.2;
                    double d1 = (double)pos.func_177956_o() + worldIn.field_73012_v.nextDouble() * 0.6 + 0.2;
                    double d2 = (double)pos.func_177952_p() + worldIn.field_73012_v.nextDouble() * 0.6 + 0.2;
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
                }
            }
            return true;
        }
        if (playerIn.field_71071_by.func_70448_g().func_77973_b() instanceof ItemPotion || playerIn.field_71071_by.func_70448_g().func_77973_b() instanceof ItemSplashPotion || playerIn.field_71071_by.func_70448_g().func_77973_b() instanceof ItemLingeringPotion) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntitySaltLamp) {
                if (!playerIn.field_71071_by.func_70448_g().func_77973_b().func_77636_d(playerIn.field_71071_by.func_70448_g()) && ((TileEntitySaltLamp)tileentity).isDiffusing()) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        playerIn.field_71071_by.func_70448_g().func_190918_g(1);
                        playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                    }
                    ((TileEntitySaltLamp)tileentity).clearEffects();
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                } else if (playerIn.field_71071_by.func_70448_g().func_77973_b().func_77636_d(playerIn.field_71071_by.func_70448_g())) {
                    if (!playerIn.field_71075_bZ.field_75098_d) {
                        playerIn.field_71071_by.func_70448_g().func_190918_g(1);
                        playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
                    }
                    ((TileEntitySaltLamp)tileentity).setEffects(PotionUtils.func_185189_a((ItemStack)playerIn.field_71071_by.func_70448_g()));
                    ((TileEntitySaltLamp)tileentity).diffuseEffects();
                    worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187621_J, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                }
            }
            return true;
        }
        return false;
    }

    public String getBlockName() {
        return this.blockName;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntitySaltLamp();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        switch (face) {
            case UP: {
                return BlockFaceShape.CENTER_SMALL;
            }
            case DOWN: {
                return BlockFaceShape.CENTER;
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return BlockFaceShape.CENTER_SMALL;
            }
        }
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        BlockFaceShape blockFaceShape = downState.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
        return super.func_176196_c(worldIn, pos) && (downState.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) || blockFaceShape == BlockFaceShape.SOLID || blockFaceShape == BlockFaceShape.CENTER || blockFaceShape == BlockFaceShape.MIDDLE_POLE || blockFaceShape == BlockFaceShape.CENTER_BIG || blockFaceShape == BlockFaceShape.MIDDLE_POLE_THICK);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        BlockFaceShape blockFaceShape = downState.func_193401_d((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP);
        if (!downState.isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP) && blockFaceShape != BlockFaceShape.SOLID && blockFaceShape != BlockFaceShape.CENTER && blockFaceShape != BlockFaceShape.MIDDLE_POLE && blockFaceShape != BlockFaceShape.CENTER_BIG && blockFaceShape != BlockFaceShape.MIDDLE_POLE_THICK) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntitySaltLamp && ((TileEntitySaltLamp)tileentity).isDiffusing()) {
            for (int i = 0; i < 1; ++i) {
                double d0 = (float)pos.func_177958_n() + 0.4f + rand.nextFloat() * 0.2f;
                double d1 = (float)pos.func_177956_o() + 0.7f + rand.nextFloat() * 0.3f;
                double d2 = (float)pos.func_177952_p() + 0.4f + rand.nextFloat() * 0.2f;
                int particleColor = ((TileEntitySaltLamp)tileentity).getParticleColor();
                int colorRed = particleColor >> 16 & 0xFF;
                int colorBlue = particleColor >> 8 & 0xFF;
                int colorGreen = particleColor & 0xFF;
                worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, d0, d1, d2, (double)((float)colorRed / 255.0f), (double)((float)colorBlue / 255.0f), (double)((float)colorGreen / 255.0f), new int[0]);
            }
        }
    }
}

