/*
 * Decompiled with CFR 0.152.
 */
package c4.corpsecomplex.common.modules.compatibility.reskillable;

import c4.corpsecomplex.common.Module;
import c4.corpsecomplex.common.Submodule;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.event.LevelUpEvent;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ReskillableModule
extends Submodule {
    static boolean resetSkills;

    public ReskillableModule(Module parentModule) {
        super(parentModule, null);
    }

    @Override
    public void loadModuleConfig() {
        resetSkills = this.getBool("Reset Skills on Respawn", false, "Set to true to reset Reskillable skills on respawn", false);
    }

    @Override
    public boolean hasEvents() {
        return true;
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        if (resetSkills && !evt.isEndConquered()) {
            EntityPlayerMP player = (EntityPlayerMP)evt.player;
            PlayerData data = PlayerDataHandler.get((EntityPlayer)player);
            Collection allSkills = data.getAllSkillInfo();
            for (PlayerSkillInfo skillInfo : allSkills) {
                int oldLevel = skillInfo.getLevel();
                if (MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Pre((EntityPlayer)player, skillInfo.skill, 1, oldLevel))) continue;
                skillInfo.setLevel(1);
                skillInfo.respec();
                MinecraftForge.EVENT_BUS.post((Event)new LevelUpEvent.Post((EntityPlayer)player, skillInfo.skill, 1, oldLevel));
            }
            data.saveAndSync();
        }
    }
}

