/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import com.google.common.collect.Sets;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.ITransformation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.render.CharsetFaceBakery;
import pl.asie.charset.lib.utils.EntityUtils;
import pl.asie.charset.lib.utils.ItemUtils;

public final class RenderUtils {
    private static RenderItem renderItem;
    private static final int[] selectionMask;

    private RenderUtils() {
    }

    public static BakedQuad createQuad(Vector3f from, Vector3f to, @Nonnull EnumFacing facing, TextureAtlasSprite sprite, int tintIndex) {
        Vector3f fFrom = new Vector3f((ReadableVector3f)from);
        Vector3f fTo = new Vector3f((ReadableVector3f)to);
        EnumFacing.AxisDirection facingDir = facing.func_176743_c();
        switch (facing.func_176740_k()) {
            case X: {
                fTo.x = facingDir == EnumFacing.AxisDirection.POSITIVE ? to.x : from.x;
                fFrom.x = fTo.x;
                break;
            }
            case Y: {
                fTo.y = facingDir == EnumFacing.AxisDirection.POSITIVE ? to.y : from.y;
                fFrom.y = fTo.y;
                break;
            }
            case Z: {
                fTo.z = facingDir == EnumFacing.AxisDirection.POSITIVE ? to.z : from.z;
                fFrom.z = fTo.z;
            }
        }
        return CharsetFaceBakery.INSTANCE.makeBakedQuad(fFrom, fTo, tintIndex, sprite, facing, (ITransformation)ModelRotation.X0_Y0, true);
    }

    public static int getAverageColor(TextureAtlasSprite sprite, AveragingMode mode) {
        if (sprite == null) {
            return -65281;
        }
        int pixelCount = 0;
        int[] data = sprite.func_147965_a(0)[0];
        long avgColorB = 0L;
        long avgColorG = 0L;
        long avgColorR = 0L;
        switch (mode) {
            case FULL: {
                for (int j = 0; j < sprite.func_94216_b(); ++j) {
                    for (int i = 0; i < sprite.func_94211_a(); ++i) {
                        int c = data[j * sprite.func_94211_a() + i];
                        if ((c >> 24 & 0xFF) == 0) continue;
                        avgColorB += (long)((c & 0xFF) * (c & 0xFF));
                        avgColorG += (long)((c >> 8 & 0xFF) * (c >> 8 & 0xFF));
                        avgColorR += (long)((c >> 16 & 0xFF) * (c >> 16 & 0xFF));
                        ++pixelCount;
                    }
                }
                break;
            }
            case H_EDGES_ONLY: {
                for (int j = 0; j < 2; ++j) {
                    for (int i = 0; i < sprite.func_94216_b(); ++i) {
                        int c = data[i * sprite.func_94211_a() + (j > 0 ? sprite.func_94211_a() - 1 : 0)];
                        if ((c >> 24 & 0xFF) == 0) continue;
                        avgColorB += (long)((c & 0xFF) * (c & 0xFF));
                        avgColorG += (long)((c >> 8 & 0xFF) * (c >> 8 & 0xFF));
                        avgColorR += (long)((c >> 16 & 0xFF) * (c >> 16 & 0xFF));
                        ++pixelCount;
                    }
                }
                break;
            }
            case V_EDGES_ONLY: {
                for (int j = 0; j < 2; ++j) {
                    for (int i = 0; i < sprite.func_94211_a(); ++i) {
                        int c = data[j > 0 ? data.length - 1 - i : i];
                        if ((c >> 24 & 0xFF) == 0) continue;
                        avgColorB += (long)((c & 0xFF) * (c & 0xFF));
                        avgColorG += (long)((c >> 8 & 0xFF) * (c >> 8 & 0xFF));
                        avgColorR += (long)((c >> 16 & 0xFF) * (c >> 16 & 0xFF));
                        ++pixelCount;
                    }
                }
                break;
            }
        }
        if (pixelCount > 0) {
            return 0xFF000000 | Math.min(255, (int)Math.sqrt(avgColorB / (long)pixelCount)) & 0xFF | (Math.min(255, (int)Math.sqrt(avgColorG / (long)pixelCount)) & 0xFF) << 8 | (Math.min(255, (int)Math.sqrt(avgColorR / (long)pixelCount)) & 0xFF) << 16;
        }
        return -65281;
    }

    public static BufferedImage getTextureImage(TextureAtlasSprite sprite) {
        int[][] dataM;
        if (sprite.func_110970_k() > 0 && (dataM = sprite.func_147965_a(0)).length > 0) {
            int[] data = dataM[0];
            BufferedImage image = new BufferedImage(sprite.func_94211_a(), sprite.func_94216_b(), 2);
            image.setRGB(0, 0, image.getWidth(), image.getHeight(), data, 0, image.getWidth());
            return image;
        }
        return null;
    }

    public static ResourceLocation toTextureFilePath(ResourceLocation location) {
        ResourceLocation pngLocation = new ResourceLocation(location.func_110624_b(), String.format("%s/%s%s", "textures", location.func_110623_a(), ".png"));
        return pngLocation;
    }

    /*
     * Exception decompiling
     */
    public static BufferedImage getTextureImage(ResourceLocation location, @Nullable Function<ResourceLocation, TextureAtlasSprite> getter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IBakedModel getItemModel(ItemStack stack) {
        return RenderUtils.getItemModel(stack, null, null);
    }

    public static IBakedModel getItemModel(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        if (renderItem == null) {
            renderItem = Minecraft.func_71410_x().func_175599_af();
        }
        return renderItem.func_184393_a(stack, world, entity);
    }

    public static TextureAtlasSprite[] getBlockSprites(ItemStack stack) {
        return RenderUtils.getBlockSprites(stack, null, null);
    }

    public static TextureAtlasSprite[] getBlockSprites(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
        TextureAtlasSprite[] sprites = new TextureAtlasSprite[6];
        try {
            IBakedModel model;
            IBakedModel missingModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            IBlockState state = null;
            if (stack.func_77973_b() instanceof ItemBlock) {
                state = ItemUtils.getBlockState(stack);
                model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
                if (model == missingModel) {
                    model = RenderUtils.getItemModel(stack, world, entity);
                }
            } else {
                model = RenderUtils.getItemModel(stack, world, entity);
            }
            if (model != missingModel) {
                List generalQuads = model.func_188616_a(state, null, 0L);
                for (EnumFacing f : EnumFacing.field_82609_l) {
                    List quads = model.func_188616_a(state, f, 0L);
                    Set foundTextures = quads.stream().map(BakedQuad::func_187508_a).collect(Collectors.toCollection(Sets::newIdentityHashSet));
                    if (foundTextures.size() != 1 && (foundTextures = quads.stream().filter(q -> q.func_178210_d() == f || q.func_178210_d() == null).map(BakedQuad::func_187508_a).collect(Collectors.toCollection(Sets::newIdentityHashSet))).size() != 1 && (foundTextures = quads.stream().filter(q -> q.func_178210_d() == f).map(BakedQuad::func_187508_a).collect(Collectors.toCollection(Sets::newIdentityHashSet))).size() != 1 && (foundTextures = generalQuads.stream().map(BakedQuad::func_187508_a).collect(Collectors.toCollection(Sets::newIdentityHashSet))).size() != 1) {
                        foundTextures = generalQuads.stream().filter(q -> q.func_178210_d() == f).map(BakedQuad::func_187508_a).collect(Collectors.toCollection(Sets::newIdentityHashSet));
                    }
                    sprites[f.ordinal()] = foundTextures.size() == 1 ? (TextureAtlasSprite)foundTextures.iterator().next() : model.func_177554_e();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sprites;
    }

    public static TextureAtlasSprite getItemSprite(ItemStack stack) {
        return RenderUtils.getItemSprite(stack, null);
    }

    public static TextureAtlasSprite getItemSprite(ItemStack stack, @Nullable EnumFacing facing) {
        return RenderUtils.getItemSprite(stack, null, null, facing);
    }

    public static TextureAtlasSprite getItemSprite(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity, @Nullable EnumFacing facing) {
        if (facing == null) {
            IBakedModel model = RenderUtils.getItemModel(stack, world, entity);
            TextureAtlasSprite sprite = model.func_177554_e();
            if ("missingno".equals(sprite.func_94215_i())) {
                try {
                    Set foundTextures = Sets.newIdentityHashSet();
                    for (EnumFacing f : EnumFacing.field_82609_l) {
                        for (BakedQuad q : model.func_188616_a(null, f, 0L)) {
                            foundTextures.add(q.func_187508_a());
                        }
                    }
                    for (BakedQuad q : model.func_188616_a(null, null, 0L)) {
                        foundTextures.add(q.func_187508_a());
                    }
                    foundTextures.remove(sprite);
                    if (foundTextures.size() == 1) {
                        return (TextureAtlasSprite)foundTextures.iterator().next();
                    }
                }
                catch (Exception foundTextures) {
                    // empty catch block
                }
            }
            return sprite;
        }
        try {
            IBakedModel model;
            IBakedModel missingModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            IBlockState state = null;
            if (stack.func_77973_b() instanceof ItemBlock) {
                state = ItemUtils.getBlockState(stack);
                model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
                if (model == missingModel) {
                    model = RenderUtils.getItemModel(stack, world, entity);
                }
            } else {
                model = RenderUtils.getItemModel(stack, world, entity);
            }
            if (model != missingModel) {
                Set foundTextures = Sets.newIdentityHashSet();
                for (BakedQuad quad : model.func_188616_a(state, facing, 0L)) {
                    foundTextures.add(quad.func_187508_a());
                }
                if (foundTextures.size() == 1) {
                    return (TextureAtlasSprite)foundTextures.iterator().next();
                }
                if (foundTextures.isEmpty()) {
                    for (BakedQuad quad : model.func_188616_a(state, null, 0L)) {
                        if (quad.func_178210_d() != facing) continue;
                        foundTextures.add(quad.func_187508_a());
                    }
                    if (foundTextures.size() == 1) {
                        return (TextureAtlasSprite)foundTextures.iterator().next();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return RenderUtils.getItemSprite(stack, world, entity, null);
    }

    public static int asMcIntColor(float[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < 0.0f) {
                data[i] = 0.0f;
                continue;
            }
            if (!(data[i] > 1.0f)) continue;
            data[i] = 1.0f;
        }
        int color = Math.round(data[0] * 255.0f) << 16 | Math.round(data[1] * 255.0f) << 8 | Math.round(data[2] * 255.0f);
        color = data.length >= 4 ? (color |= Math.round(data[3] * 255.0f) << 24) : (color |= 0xFF000000);
        return color;
    }

    public static int asMcIntColor(double[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < 0.0) {
                data[i] = 0.0;
                continue;
            }
            if (!(data[i] > 1.0)) continue;
            data[i] = 1.0;
        }
        int color = (int)Math.round(data[0] * 255.0) << 16 | (int)Math.round(data[1] * 255.0) << 8 | (int)Math.round(data[2] * 255.0);
        color = data.length >= 4 ? (color |= (int)Math.round(data[3] * 255.0) << 24) : (color |= 0xFF000000);
        return color;
    }

    public static void glColor(int color) {
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    public static void glColor(int color, float alpha) {
        GlStateManager.func_179131_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f * alpha));
    }

    public static float[] calculateUV(Vector3f from, Vector3f to, EnumFacing facing1) {
        EnumFacing facing;
        if (to.y > 16.0f) {
            from = new Vector3f((ReadableVector3f)from);
            to = new Vector3f((ReadableVector3f)to);
            while (to.y > 16.0f) {
                from.y -= 16.0f;
                to.y -= 16.0f;
            }
        }
        if ((facing = facing1) == null) {
            if (from.y == to.y) {
                facing = EnumFacing.UP;
            } else if (from.x == to.x) {
                facing = EnumFacing.EAST;
            } else if (from.z == to.z) {
                facing = EnumFacing.SOUTH;
            } else {
                return null;
            }
        }
        switch (facing) {
            case DOWN: {
                return new float[]{from.x, 16.0f - to.z, to.x, 16.0f - from.z};
            }
            case UP: {
                return new float[]{from.x, from.z, to.x, to.z};
            }
            case NORTH: {
                return new float[]{16.0f - to.x, 16.0f - to.y, 16.0f - from.x, 16.0f - from.y};
            }
            case SOUTH: {
                return new float[]{from.x, 16.0f - to.y, to.x, 16.0f - from.y};
            }
            case WEST: {
                return new float[]{from.z, 16.0f - to.y, to.z, 16.0f - from.y};
            }
            case EAST: {
                return new float[]{16.0f - to.z, 16.0f - to.y, 16.0f - from.z, 16.0f - from.y};
            }
        }
        return null;
    }

    public static IModel getModel(ResourceLocation location) {
        try {
            return ModelLoaderRegistry.getModel((ResourceLocation)location);
        }
        catch (Exception e) {
            ModCharset.logger.error("Model " + location.toString() + " is missing! THIS WILL CAUSE A CRASH!");
            e.printStackTrace();
            return null;
        }
    }

    public static IModel getModelWithTextures(ResourceLocation location, TextureMap map) {
        IModel model = RenderUtils.getModel(location);
        if (model != null) {
            for (ResourceLocation tlocation : RenderUtils.getAllTextures(model)) {
                map.func_174942_a(tlocation);
            }
        }
        return model;
    }

    public static Collection<ResourceLocation> getAllTextures(IModel model) {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>(model.getTextures());
        LinkedList locs = new LinkedList();
        locs.addAll(model.getDependencies());
        while (!locs.isEmpty()) {
            IModel m = RenderUtils.getModel((ResourceLocation)locs.remove());
            if (m == null) continue;
            textures.addAll(m.getTextures());
            locs.addAll(m.getDependencies());
        }
        return textures;
    }

    private static int getSelectionMask(int y, int x, int z) {
        return 1 << y * 4 + x * 2 + z;
    }

    private static void drawLine(BufferBuilder worldrenderer, Tessellator tessellator, double x1, double y1, double z1, double x2, double y2, double z2) {
        worldrenderer.func_181662_b(x1, y1, z1).func_181675_d();
        worldrenderer.func_181662_b(x2, y2, z2).func_181675_d();
    }

    public static int getSelectionMask(EnumFacing face) {
        return selectionMask[face.ordinal()];
    }

    public static void drawSelectionBoundingBox(AxisAlignedBB box, int lineMask) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        Vec3d cameraPos = EntityUtils.interpolate((Entity)player, partialTicks);
        AxisAlignedBB boundingBox = box.func_186662_g(0.002).func_191194_a(cameraPos.func_186678_a(-1.0));
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        GL11.glLineWidth((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        if ((lineMask & 1) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c);
        }
        if ((lineMask & 2) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        }
        if ((lineMask & 4) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f);
        }
        if ((lineMask & 8) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f);
        }
        if ((lineMask & 0x10) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c);
        }
        if ((lineMask & 0x20) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        if ((lineMask & 0x40) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        }
        if ((lineMask & 0x80) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        if ((lineMask & 0x100) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c);
        }
        if ((lineMask & 0x200) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        if ((lineMask & 0x400) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        if ((lineMask & 0x800) != 0) {
            RenderUtils.drawLine(worldrenderer, tessellator, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c, boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static int multiplyColor(int src, int dst) {
        int out = 0;
        for (int i = 0; i < 32; i += 8) {
            out |= ((src >> i & 0xFF) * (dst >> i & 0xFF) / 255 & 0xFF) << i;
        }
        return out;
    }

    static {
        selectionMask = new int[6];
        RenderUtils.selectionMask[0] = 15;
        RenderUtils.selectionMask[1] = 3840;
        int lineMask = 0;
        lineMask |= RenderUtils.getSelectionMask(1, 0, 0);
        lineMask |= RenderUtils.getSelectionMask(1, 1, 0);
        lineMask |= RenderUtils.getSelectionMask(0, 0, 0);
        RenderUtils.selectionMask[2] = lineMask |= RenderUtils.getSelectionMask(2, 0, 0);
        lineMask = 0;
        lineMask |= RenderUtils.getSelectionMask(1, 0, 1);
        lineMask |= RenderUtils.getSelectionMask(1, 1, 1);
        lineMask |= RenderUtils.getSelectionMask(0, 0, 1);
        RenderUtils.selectionMask[3] = lineMask |= RenderUtils.getSelectionMask(2, 0, 1);
        lineMask = 0;
        lineMask |= RenderUtils.getSelectionMask(1, 0, 0);
        lineMask |= RenderUtils.getSelectionMask(1, 0, 1);
        lineMask |= RenderUtils.getSelectionMask(0, 1, 0);
        RenderUtils.selectionMask[4] = lineMask |= RenderUtils.getSelectionMask(2, 1, 0);
        lineMask = 0;
        lineMask |= RenderUtils.getSelectionMask(1, 1, 0);
        lineMask |= RenderUtils.getSelectionMask(1, 1, 1);
        lineMask |= RenderUtils.getSelectionMask(0, 1, 1);
        RenderUtils.selectionMask[5] = lineMask |= RenderUtils.getSelectionMask(2, 1, 1);
    }

    public static enum AveragingMode {
        FULL,
        H_EDGES_ONLY,
        V_EDGES_ONLY;

    }
}

