/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.inventory;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.items.IItemHandlerModifiable;
import pl.asie.charset.lib.inventory.ReverseInvWrapper;

public class LootTableHandler {
    private final IItemHandlerModifiable parent;
    private ResourceLocation lootTable;
    private long lootTableSeed;

    public LootTableHandler(IItemHandlerModifiable parent) {
        this.parent = parent;
    }

    public boolean readFromNBT(NBTTagCompound compound) {
        if (compound.func_150297_b("LootTable", 8)) {
            this.lootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            this.lootTableSeed = compound.func_74763_f("LootTableSeed");
            return true;
        }
        return false;
    }

    public boolean writeToNBT(NBTTagCompound compound) {
        if (this.lootTable != null) {
            compound.func_74778_a("LootTable", this.lootTable.toString());
            if (this.lootTableSeed != 0L) {
                compound.func_74772_a("LootTableSeed", this.lootTableSeed);
            }
            return true;
        }
        return false;
    }

    public void applyFrom(World world, @Nullable EntityPlayer player) {
        if (this.lootTable != null) {
            LootTable table = world.func_184146_ak().func_186521_a(this.lootTable);
            this.lootTable = null;
            Random random = this.lootTableSeed == 0L ? new Random() : new Random(this.lootTableSeed);
            LootContext.Builder builder = new LootContext.Builder((WorldServer)world);
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_186470_a(player);
            }
            table.func_186460_a((IInventory)new ReverseInvWrapper(this.parent), random, builder.func_186471_a());
        }
    }

    public ResourceLocation getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(ResourceLocation lootTableLocation, long lootTableSeed) {
        this.lootTable = lootTableLocation;
        this.lootTableSeed = lootTableSeed;
    }
}

