/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.handlers;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.CharsetLib;
import pl.asie.charset.lib.handlers.PacketRequestScroll;

public class ShiftScrollHandler {
    public static ShiftScrollHandler INSTANCE = new ShiftScrollHandler();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final List<Entry> providers = new ArrayList<Entry>();

    private ShiftScrollHandler() {
    }

    public void loadCustomRules() {
        File rulesDir = new File(new File(ModCharset.getConfigDir(), "module"), "lib.shiftScroll");
        if (!rulesDir.isDirectory()) {
            rulesDir.mkdirs();
        }
        File defaultRulesFile = new File(rulesDir, "rules.json.default");
        ArrayList defaultRules = new ArrayList();
        for (Entry e : this.providers) {
            Provider p = e.provider;
            HashMap<String, Object> providerMap = new HashMap<String, Object>();
            if (p instanceof ItemGroup) {
                ArrayList<String> itemNames = new ArrayList<String>();
                for (Item i : ((ItemGroup)p).items) {
                    itemNames.add(i.getRegistryName().toString());
                }
                if (itemNames.size() == 1) {
                    providerMap.put("item", itemNames.get(0));
                } else {
                    providerMap.put("items", itemNames);
                }
            } else if (p instanceof ItemGroupMetadataLimited) {
                providerMap.put("item", ((ItemGroupMetadataLimited)p).item.getRegistryName().toString());
                providerMap.put("minMeta", ((ItemGroupMetadataLimited)p).minMeta);
                providerMap.put("maxMeta", ((ItemGroupMetadataLimited)p).maxMeta);
            } else if (p instanceof OreDictionaryGroup) {
                providerMap.put("oreName", ((OreDictionaryGroup)p).oreName);
            } else {
                ModCharset.logger.warn("Could not JSONify " + p.getClass().getName() + "!");
                continue;
            }
            if (e.alwaysCreative) {
                providerMap.put("alwaysCreative", true);
            }
            defaultRules.add(providerMap);
        }
        try {
            Files.write(defaultRulesFile.toPath(), this.gson.toJson(defaultRules).getBytes(Charsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList filesToCheck = Lists.newArrayList();
        for (File f : rulesDir.listFiles()) {
            if (!f.isFile() || !f.getName().endsWith(".json")) continue;
            if (f.getName().equals("rules.json")) {
                this.providers.clear();
            }
            filesToCheck.add(f);
        }
        for (File f : filesToCheck) {
            try {
                List deserialized = (List)this.gson.fromJson((Reader)Files.newBufferedReader(f.toPath()), List.class);
                for (Object o : deserialized) {
                    if (!(o instanceof Map)) continue;
                    try {
                        Map m = (Map)o;
                        Provider provider = null;
                        boolean alwaysCreative = m.getOrDefault("alwaysCreative", false);
                        if (m.containsKey("items")) {
                            Object oo = m.get("items");
                            if (oo instanceof Collection) {
                                ArrayList<Item> items = new ArrayList<Item>();
                                for (String s : (Collection)oo) {
                                    Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
                                    if (i == Item.func_150898_a((Block)Blocks.field_150350_a)) continue;
                                    items.add(i);
                                }
                                provider = new ItemGroup(items);
                            }
                        } else if (m.containsKey("item")) {
                            Item i = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)m.get("item")));
                            if (i != Item.func_150898_a((Block)Blocks.field_150350_a)) {
                                provider = m.containsKey("minMeta") ? new ItemGroupMetadataLimited(i, (Integer)m.get("minMeta"), (Integer)m.get("maxMeta")) : new ItemGroup(i);
                            }
                        } else if (m.containsKey("oreName")) {
                            provider = new OreDictionaryGroup((String)m.get("oreName"));
                        }
                        if (provider == null) continue;
                        this.providers.add(new Entry(provider, alwaysCreative));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Nullable
    public Entry getMatchingProvider(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (Entry p : this.providers) {
            if (!p.getProvider().matches(stack)) continue;
            return p;
        }
        return null;
    }

    public void register(Provider provider) {
        this.providers.add(new Entry(provider, false));
    }

    public void register(Entry provider) {
        this.providers.add(provider);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouse(MouseEvent event) {
        EntityPlayerSP player;
        ItemStack currStack;
        int wheel = event.getDwheel();
        if (wheel != 0 && Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d() && !(currStack = (player = Minecraft.func_71410_x().field_71439_g).func_184614_ca()).func_190926_b() && this.getMatchingProvider(currStack) != null) {
            event.setCanceled(true);
            CharsetLib.packet.sendToServer(new PacketRequestScroll(player.field_71071_by.field_70461_c, wheel));
        }
    }

    public static class OreDictionaryGroup
    implements Provider {
        private final String oreName;
        private final transient int oreId;
        private final transient NonNullList<ItemStack> items;

        public OreDictionaryGroup(String oreName) {
            this.oreName = oreName;
            this.oreId = OreDictionary.getOreID((String)oreName);
            this.items = OreDictionary.getOres((String)oreName);
        }

        @Override
        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)stack), (int)this.oreId);
        }

        @Override
        public void addAllMatching(NonNullList<ItemStack> list) {
            for (ItemStack stack : this.items) {
                if (stack.func_77952_i() == Short.MAX_VALUE) {
                    stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, list);
                    continue;
                }
                list.add((Object)stack);
            }
        }
    }

    public static class ItemGroupMetadataLimited
    implements Provider {
        private final Item item;
        private final int minMeta;
        private final int maxMeta;

        public ItemGroupMetadataLimited(Item i, int minMeta, int maxMeta) {
            this.item = i;
            this.minMeta = minMeta;
            this.maxMeta = maxMeta;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() == this.item && stack.func_77952_i() >= this.minMeta && stack.func_77952_i() <= this.maxMeta;
        }

        @Override
        public void addAllMatching(NonNullList<ItemStack> list) {
            NonNullList filteredList = NonNullList.func_191196_a();
            this.item.func_150895_a(CreativeTabs.field_78027_g, filteredList);
            for (ItemStack stack : filteredList) {
                if (stack.func_77952_i() < this.minMeta || stack.func_77952_i() > this.maxMeta) continue;
                list.add((Object)stack);
            }
        }
    }

    public static class ItemGroup
    implements Provider {
        private final Set<Item> items = new LinkedHashSet<Item>();

        public ItemGroup(Collection c) {
            for (Object o : c) {
                if (o instanceof Block) {
                    this.items.add(Item.func_150898_a((Block)((Block)o)));
                    continue;
                }
                if (!(o instanceof Item)) continue;
                this.items.add((Item)o);
            }
        }

        public ItemGroup(Block ... blocks) {
            for (Block b : blocks) {
                this.items.add(Item.func_150898_a((Block)b));
            }
        }

        public ItemGroup(Item ... its) {
            this.items.addAll(Arrays.asList(its));
        }

        @Override
        public boolean matches(ItemStack stack) {
            return !stack.func_190926_b() && this.items.contains(stack.func_77973_b());
        }

        @Override
        public void addAllMatching(NonNullList<ItemStack> list) {
            for (Item i : this.items) {
                i.func_150895_a(CreativeTabs.field_78027_g, list);
            }
        }
    }

    public static interface Provider {
        public boolean matches(ItemStack var1);

        public void addAllMatching(NonNullList<ItemStack> var1);
    }

    public static final class Entry {
        private final Provider provider;
        private final boolean alwaysCreative;

        public Entry(Provider provider, boolean alwaysCreative) {
            this.provider = provider;
            this.alwaysCreative = alwaysCreative;
        }

        public boolean isAlwaysCreative() {
            return this.alwaysCreative;
        }

        public Provider getProvider() {
            return this.provider;
        }
    }
}

