/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.command;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import pl.asie.charset.lib.command.SubCommand;

public class CommandCharset
extends CommandBase {
    public static final Joiner COMMAS = Joiner.on((String)", ");
    public static final CommandCharset CLIENT = new CommandCharset(Side.CLIENT);
    public static final CommandCharset SERVER = new CommandCharset(Side.SERVER);
    final List<SubCommand> SUB_COMMANDS = new ArrayList<SubCommand>();
    final Map<String, SubCommand> SUB_COMMAND_MAP = new HashMap<String, SubCommand>();
    final Side side;

    private void registerInternal(SubCommand command) {
        if (this.SUB_COMMANDS.add(command)) {
            this.SUB_COMMAND_MAP.put(command.getName().toLowerCase(Locale.ROOT), command);
            for (String s : command.getAliases()) {
                this.SUB_COMMAND_MAP.put(s.toLowerCase(Locale.ROOT), command);
            }
        }
    }

    public static void register(SubCommand command) {
        if (command.getSide() == Side.CLIENT) {
            CLIENT.registerInternal(command);
        } else {
            SERVER.registerInternal(command);
        }
    }

    private CommandCharset(Side side) {
        this.side = side;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            ArrayList<String> cmds = new ArrayList<String>();
            for (Map.Entry<String, SubCommand> cmdEntry : this.SUB_COMMAND_MAP.entrySet()) {
                if (!sender.func_70003_b(cmdEntry.getValue().getPermissionLevel(), this.func_71517_b())) continue;
                cmds.add(cmdEntry.getKey());
            }
            return CommandCharset.func_175762_a((String[])args, cmds);
        }
        if (args.length > 1) {
            SubCommand command = this.SUB_COMMAND_MAP.get(args[0].toLowerCase(Locale.ROOT));
            if (command != null) {
                String[] args2 = new String[args.length - 1];
                System.arraycopy(args, 1, args2, 0, args.length - 1);
                return command.getTabCompletions(server, sender, args2);
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public int func_82362_a() {
        return 0;
    }

    public List<String> func_71514_a() {
        return ImmutableList.of((Object)(this.side == Side.CLIENT ? "chc" : "ch"));
    }

    public String func_71517_b() {
        return this.side == Side.CLIENT ? "charsetc" : "charset";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " [" + COMMAS.join((Iterable)this.SUB_COMMANDS.stream().filter(cmd -> sender.func_70003_b(cmd.getPermissionLevel(), "charset")).filter(cmd -> cmd.getSide() == this.side).map(SubCommand::getName).collect(Collectors.toList())) + "]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            String[] args2 = new String[args.length - 1];
            System.arraycopy(args, 1, args2, 0, args.length - 1);
            SubCommand command = this.SUB_COMMAND_MAP.get(args[0].toLowerCase(Locale.ROOT));
            if (command != null) {
                if (sender.func_70003_b(command.getPermissionLevel(), this.func_71517_b())) {
                    command.execute(server, sender, args2);
                } else {
                    sender.func_145747_a(new TextComponentTranslation("commands.generic.permission", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            } else {
                sender.func_145747_a(new TextComponentTranslation("commands.generic.parameter.invalid", new Object[]{args[0]}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(this.func_71518_a(sender)));
        }
    }
}

