/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.capability.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import pl.asie.charset.api.lib.IDyeableItem;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.utils.ItemUtils;

public class DyeableItemStack
implements IDyeableItem,
ICapabilityProvider {
    private final boolean storesAlpha;
    private final int colorCount;
    private final ItemStack stack;

    public DyeableItemStack(ItemStack stack) {
        this(stack, 1, false);
    }

    public DyeableItemStack(ItemStack stack, int count, boolean alpha) {
        this.stack = stack;
        this.colorCount = count;
        this.storesAlpha = alpha;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == Capabilities.DYEABLE_ITEM;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == Capabilities.DYEABLE_ITEM ? Capabilities.DYEABLE_ITEM.cast((Object)this) : null);
    }

    protected String getKey(int c) {
        return this.getColorSlotCount() == 1 ? "color" : "color" + c;
    }

    @Override
    public int getColorSlotCount() {
        return this.colorCount;
    }

    @Override
    public int getColor(int slot) {
        String key;
        NBTTagCompound cpd;
        if (this.stack.func_77942_o() && (cpd = this.stack.func_77978_p()).func_150297_b(key = this.getKey(slot), 99)) {
            return cpd.func_74762_e(key);
        }
        return -1;
    }

    @Override
    public boolean hasColor(int slot) {
        return this.stack.func_77942_o() && this.stack.func_77978_p().func_74764_b(this.getKey(slot));
    }

    @Override
    public boolean removeColor(int slot) {
        String key;
        NBTTagCompound cpd;
        if (this.stack.func_77942_o() && (cpd = this.stack.func_77978_p()).func_150297_b(key = this.getKey(slot), 99)) {
            cpd.func_82580_o(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean setColor(int slot, int color) {
        if (!this.storesAlpha) {
            color |= 0xFF000000;
        }
        ItemUtils.getTagCompound(this.stack, true).func_74768_a(this.getKey(slot), color);
        return true;
    }
}

