/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.audio.types;

import io.netty.buffer.ByteBuf;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioDataPCM;
import pl.asie.charset.lib.audio.AudioUtils;
import pl.asie.charset.lib.audio.codec.DFPWM;

public class AudioDataDFPWM
extends AudioData
implements IAudioDataPCM {
    protected byte[] decodedData;
    private byte[] data;
    private int time;
    private static final DFPWM dfpwm = new DFPWM();
    private transient int sourceId;

    public AudioDataDFPWM() {
    }

    public AudioDataDFPWM(byte[] data, int time) {
        this.data = data;
        this.time = time;
    }

    public AudioDataDFPWM setSourceId(int id) {
        this.sourceId = id;
        return this;
    }

    @Override
    public int getSampleRate() {
        int samples = this.data.length * 8;
        return samples * 1000 / this.time;
    }

    @Override
    public int getSampleSize() {
        return 1;
    }

    @Override
    public boolean isSampleSigned() {
        return true;
    }

    @Override
    public boolean isSampleBigEndian() {
        return false;
    }

    @Override
    public byte[] getSamplePCMData() {
        if (this.decodedData == null) {
            this.decodedData = new byte[this.data.length * 8];
            dfpwm.decompress(this.decodedData, this.data, 0, 0, this.data.length);
        }
        return this.decodedData;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void readData(ByteBuf buf) {
        this.time = buf.readUnsignedMedium();
        this.data = new byte[buf.readUnsignedShort()];
        buf.readBytes(this.data);
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeMedium(this.time);
        buf.writeShort(this.data.length);
        buf.writeBytes(this.data);
    }

    @Override
    protected void sendClient(AudioPacket packet) {
        AudioUtils.send(this.sourceId, packet);
    }
}

