/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenMound;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilightThick;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenUndergroundRoots;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class TreeTwilightOak
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:twilight_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:twilight_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176203_a(0);
    public static int logsMeta = 0;
    public static int saplingMeta = 0;
    public static int saplingMetaRobust = 4;
    public static BlockSurfaceRoot twilightRoots;
    public static Species sicklySpecies;

    public TreeTwilightOak() {
        super(new ResourceLocation("dynamictreesttf", "twilightOak"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        ModContent.sicklyTwilightOakLeavesProperties.setTree((TreeFamily)this);
        ModContent.robustTwilightOakLeavesProperties.setTree((TreeFamily)this);
        twilightRoots = new BlockSurfaceRoot(Material.field_151575_d, "twilight_roots");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesRobustTwilightOak(this));
        sicklySpecies = new SpeciesSicklyTwilightOak(this);
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
        speciesRegistry.register((IForgeRegistryEntry)sicklySpecies);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        itemList.add((Item)sicklySpecies.getSeed());
        return super.getRegisterableItems(itemList);
    }

    public boolean isThick() {
        return true;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)twilightRoots);
        return super.getRegisterableBlocks(blockList);
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return twilightRoots;
    }

    public BlockBranch createBranch() {
        String branchName = "twilightOakbranch";
        return new BlockBranchTwilightThick(branchName);
    }

    public class SpeciesSicklyTwilightOak
    extends Species {
        SpeciesSicklyTwilightOak(TreeFamily treeFamily) {
            super(new ResourceLocation("dynamictreesttf", "twilightOakSickly"), treeFamily, ModContent.sicklyTwilightOakLeavesProperties);
            this.setRequiresTileEntity(true);
            this.setBasicGrowingParameters(this.tapering, 9.0f, this.upProbability, this.lowestBranchHeight, this.growthRate);
            this.generateSeed();
            this.setupStandardSeedDropping();
        }

        public Species generateSeed() {
            Seed seed = new Seed("sicklyTwilightOakSeed");
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }
    }

    public class SpeciesRobustTwilightOak
    extends Species {
        SpeciesRobustTwilightOak(TreeFamily treeFamily) {
            super(new ResourceLocation("dynamictreesttf", "twilightOakRobust"), treeFamily, ModContent.robustTwilightOakLeavesProperties);
            this.setBasicGrowingParameters(0.4f, 25.0f, 50, 15, 1.5f);
            this.setSoilLongevity(50);
            this.generateSeed();
            this.addGenFeature((IGenFeature)new FeatureGenUndergroundRoots(ModContent.undergroundRoot, ModContent.undergroundRootExposed, 8, 20, 10));
            this.addGenFeature((IGenFeature)new FeatureGenMound(6));
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(20));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(10).setScaler(this.getRootScaler()));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 13 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public Species generateSeed() {
            Seed seed = new Seed("robustTwilightOakSeed");
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }

        public boolean isThick() {
            return true;
        }

        public int maxBranchRadius() {
            return 18;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            probMap[0] = 1;
            probMap[1] = signal.isInTrunk() ? this.getUpProbability() : 0;
            probMap[5] = signal.isInTrunk() ? 1 : 20;
            probMap[4] = probMap[5];
            probMap[3] = probMap[5];
            probMap[2] = probMap[5];
            probMap[originDir.ordinal()] = 0;
            int n = signal.dir.func_176745_a();
            probMap[n] = probMap[n] * 2;
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (signal.energy < 6.0f && !signal.isInTrunk()) {
                signal.energy = 6.0f;
            }
            return newDir;
        }
    }
}

