/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.ModBlocks;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockRooty;
import com.ferreusveritas.dynamictrees.systems.DirtHelper;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import java.util.Objects;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilight;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenLogCritter;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenUndergroundRoots;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistry;
import twilightforest.biomes.TFBiomes;

public class TreeMangrove
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:twilight_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:twilight_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176203_a(2);
    public static int logsMeta = 2;
    public static int saplingMeta = 2;

    public TreeMangrove() {
        super(new ResourceLocation("dynamictreesttf", "mangrove"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        ModContent.mangroveLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMangrove(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public BlockBranch createBranch() {
        return new BlockBranchTwilight("mangroveBranch"){

            public int getMaxRadius() {
                return 6;
            }

            public BlockRenderLayer func_180664_k() {
                return BlockRenderLayer.CUTOUT_MIPPED;
            }
        };
    }

    public static class FeatureGenMangrovelings
    implements IPostGenFeature {
        public boolean postGeneration(World world, BlockPos rootPos, Species species, Biome biome, int radius, List<BlockPos> endPoints, SafeChunkBounds safeBounds, IBlockState initialDirtState) {
            int[] angles = new int[2];
            angles[0] = angles[1] = world.field_73012_v.nextInt(6);
            while (angles[0] == angles[1]) {
                angles[1] = world.field_73012_v.nextInt(6);
            }
            block1: for (int a : angles) {
                double angle = Math.toRadians((float)a * 60.0f);
                float distance = 3.0f + world.field_73012_v.nextFloat() * 2.0f;
                BlockPos offPos = rootPos.func_177971_a(new Vec3i(Math.sin(angle) * (double)distance, 0.0, Math.cos(angle) * (double)distance));
                if (!safeBounds.inBounds(offPos, true) || !species.isAcceptableSoil(world, offPos, world.func_180495_p(offPos)) || !world.func_175623_d(offPos.func_177981_b(1)) || !world.func_175623_d(offPos.func_177981_b(2))) continue;
                for (EnumFacing hor : EnumFacing.field_176754_o) {
                    BlockPos offPos2 = offPos.func_177972_a(hor);
                    if (!world.func_175623_d(offPos2.func_177981_b(1)) || !world.func_175623_d(offPos2.func_177981_b(2))) continue block1;
                }
                world.func_175656_a(offPos, species.getRootyBlock(world, offPos).func_176223_P().func_177226_a((IProperty)BlockRooty.LIFE, (Comparable)Integer.valueOf(0)));
                species.getFamily().getDynamicBranch().setRadius(world, offPos.func_177981_b(1), 1, EnumFacing.DOWN, 0);
                if (world.field_73012_v.nextInt(2) == 0) {
                    world.func_175656_a(offPos.func_177981_b(2), species.getLeavesProperties().getDynamicLeavesState(1));
                    continue;
                }
                species.getFamily().getDynamicBranch().setRadius(world, offPos.func_177981_b(2), 1, EnumFacing.DOWN, 0);
                if (!world.func_175623_d(offPos.func_177981_b(3))) continue;
                world.func_175656_a(offPos.func_177981_b(3), species.getLeavesProperties().getDynamicLeavesState(1));
            }
            return false;
        }
    }

    public class SpeciesMangrove
    extends Species {
        protected int deepSoilTypeFlags;

        SpeciesMangrove(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.mangroveLeavesProperties);
            this.setSoilLongevity(4);
            this.setBasicGrowingParameters(0.2f, 10.0f, this.upProbability, 4, 0.6f);
            this.setSeedStack(new ItemStack((Item)ModContent.mangroveSeed));
            this.setupStandardSeedDropping();
            this.addGenFeature((IGenFeature)new FeatureGenLogCritter(this.getLowestBranchHeight(), ModContent.dynamicFirefly, 80, 2));
            this.addGenFeature((IGenFeature)new FeatureGenUndergroundRoots(ModContent.undergroundRoot, ModContent.undergroundRootExposed, 6, 5, 1));
            this.addGenFeature((IGenFeature)new FeatureGenMangrovelings());
        }

        public int maxBranchRadius() {
            return 6;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            if (newDir != EnumFacing.UP) {
                signal.energy += 0.75f;
            }
            if (newDir == EnumFacing.UP && signal.dir != EnumFacing.UP) {
                signal.energy += ((float)Math.max(Math.abs(signal.delta.func_177958_n()), Math.abs(signal.delta.func_177952_p())) - 2.0f) * 1.5f;
            }
            return newDir;
        }

        public BlockRooty getRootyBlock(World world, BlockPos rootPos) {
            if (DirtHelper.isSoilAcceptable((Block)world.func_180495_p(rootPos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"waterlike"}))) {
                return ModContent.blockRootyWater;
            }
            return ModBlocks.blockRootyDirt;
        }

        public boolean isBiomePerfect(Biome biome) {
            return SpeciesMangrove.isOneOfBiomes((Biome)biome, (Biome[])new Biome[]{TFBiomes.tfSwamp, TFBiomes.fireSwamp});
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            return super.customDirectionManipulation(world, pos, radius, signal, probMap);
        }

        protected void setStandardSoils() {
            this.addAcceptableSoils(new String[]{"waterlike", "dirtlike"});
            this.deepSoilTypeFlags = DirtHelper.getSoilFlags((String[])new String[]{"dirtlike", "sandlike", "gravellike"});
        }

        public boolean isAcceptableSoil(World world, BlockPos pos, IBlockState soilBlockState) {
            boolean requiresBottom = DirtHelper.isSoilAcceptable((Block)world.func_180495_p(pos).func_177230_c(), (int)DirtHelper.getSoilFlags((String[])new String[]{"waterlike"}));
            return super.isAcceptableSoil(world, pos, soilBlockState) && (!requiresBottom || DirtHelper.isSoilAcceptable((Block)world.func_180495_p(pos.func_177977_b()).func_177230_c(), (int)this.deepSoilTypeFlags));
        }
    }
}

