/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchThick;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenRoots;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilightThick;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenTrunkCore;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenUndergroundRoots;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.enums.MagicWoodVariant;

public class TreeMagicTime
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:magic_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:magic_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176223_P().func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)MagicWoodVariant.TIME);
    public static int logsMeta = 0;
    public static int saplingMeta = 5;
    public static BlockBranchTwilightThick branch;
    public BlockSurfaceRoot timeRoots;

    public TreeMagicTime() {
        super(new ResourceLocation("dynamictreesttf", "treeOfTime"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        ModContent.timeLeavesProperties.setTree((TreeFamily)this);
        ModContent.timeCoreBranch.setFamily((TreeFamily)this);
        ModContent.timeCoreBranchOff.setFamily((TreeFamily)this);
        this.timeRoots = new BlockSurfaceRoot(Material.field_151575_d, "time_roots");
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMagicTime(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.timeRoots;
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.timeRoots);
        blockList.add((Block)((BlockBranchThick)ModContent.timeCoreBranch).getPairSide(true));
        blockList.add((Block)((BlockBranchThick)ModContent.timeCoreBranch).getPairSide(false));
        blockList.add((Block)((BlockBranchThick)ModContent.timeCoreBranchOff).getPairSide(true));
        blockList.add((Block)((BlockBranchThick)ModContent.timeCoreBranchOff).getPairSide(false));
        return super.getRegisterableBlocks(blockList);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public boolean isThick() {
        return true;
    }

    public BlockBranch createBranch() {
        String branchName = "treeOfTimeBranch";
        branch = new BlockBranchTwilightThick(branchName){

            public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
                return false;
            }
        };
        return branch;
    }

    public class SpeciesMagicTime
    extends Species {
        SpeciesMagicTime(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.timeLeavesProperties);
            this.setBasicGrowingParameters(0.8f, this.signalEnergy, this.upProbability, 4, this.growthRate);
            this.generateSeed();
            this.addGenFeature((IGenFeature)new FeatureGenUndergroundRoots(ModContent.undergroundRoot, ModContent.undergroundRootExposed, 8, 5, 3));
            this.addGenFeature((IGenFeature)new FeatureGenRoots(12).setScaler(this.getRootScaler()));
            this.addGenFeature((IGenFeature)new FeatureGenTrunkCore(ModContent.timeCoreBranchOff, 17, 3, CoordUtils.Surround.E));
        }

        protected BiFunction<Integer, Integer, Integer> getRootScaler() {
            return (inRadius, trunkRadius) -> {
                float scale = MathHelper.func_76131_a((float)(trunkRadius >= 13 ? (float)trunkRadius.intValue() / 24.0f : 0.0f), (float)0.0f, (float)1.0f);
                return (int)((float)inRadius.intValue() * scale);
            };
        }

        public Species generateSeed() {
            Seed seed = new Seed(this.getRegistryName().func_110623_a() + "seed"){

                public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                    tooltip.set(0, TextFormatting.AQUA + tooltip.get(0));
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                }
            };
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }

        public boolean isThick() {
            return true;
        }
    }
}

