/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.trees;

import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranch;
import com.ferreusveritas.dynamictrees.items.Seed;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import maxhyper.dynamictreesttf.ModContent;
import maxhyper.dynamictreesttf.blocks.BlockBranchTwilight;
import maxhyper.dynamictreesttf.blocks.BlockDynamicTwilightRoots;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenTrunkCore;
import maxhyper.dynamictreesttf.genfeatures.FeatureGenUndergroundRoots;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.enums.MagicWoodVariant;

public class TreeMagicMiners
extends TreeFamily {
    public static Block leavesBlock = Block.func_149684_b((String)"twilightforest:magic_leaves");
    public static Block logBlock = Block.func_149684_b((String)"twilightforest:magic_log");
    public static Block saplingBlock = Block.func_149684_b((String)"twilightforest:twilight_sapling");
    public static IBlockState leavesState = leavesBlock.func_176223_P().func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)MagicWoodVariant.MINE);
    public static int logsMeta = 2;
    public static int saplingMeta = 7;
    public static BlockBranchTwilight branch;

    public TreeMagicMiners() {
        super(new ResourceLocation("dynamictreesttf", "minersTree"));
        this.setPrimitiveLog(logBlock.func_176223_P(), new ItemStack(logBlock, 1, logsMeta));
        ModContent.minerCoreBranch.setFamily((TreeFamily)this);
        ModContent.minerCoreBranchOff.setFamily((TreeFamily)this);
        ModContent.minersLeavesProperties.setTree((TreeFamily)this);
        this.addConnectableVanillaLeaves(state -> state.func_177230_c() == leavesBlock);
    }

    public ItemStack getPrimitiveLogItemStack(int qty) {
        ItemStack stack = new ItemStack(Objects.requireNonNull(logBlock), 1, logsMeta);
        stack.func_190920_e(MathHelper.func_76125_a((int)qty, (int)0, (int)64));
        return stack;
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesMagicMiners(this));
    }

    public void registerSpecies(IForgeRegistry<Species> speciesRegistry) {
        super.registerSpecies(speciesRegistry);
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)ModContent.minerCoreBranch);
        blockList.add((Block)ModContent.minerCoreBranchOff);
        return super.getRegisterableBlocks(blockList);
    }

    public List<Item> getRegisterableItems(List<Item> itemList) {
        return super.getRegisterableItems(itemList);
    }

    public BlockBranch createBranch() {
        String branchName = "minersTreebranch";
        branch = new BlockBranchTwilight(branchName){

            public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
                return false;
            }
        };
        return branch;
    }

    public class SpeciesMagicMiners
    extends Species {
        SpeciesMagicMiners(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, ModContent.minersLeavesProperties);
            this.setBasicGrowingParameters(this.tapering, 16.0f, this.upProbability, 8, this.growthRate);
            this.generateSeed();
            this.addGenFeature((IGenFeature)new FeatureGenUndergroundRoots(ModContent.undergroundRoot, ModContent.undergroundRootExposed, 8, 5, 3));
            this.addGenFeature((IGenFeature)new FeatureGenTrunkCore(ModContent.minerCoreBranchOff, 7, 2));
        }

        public Species generateSeed() {
            Seed seed = new Seed(this.getRegistryName().func_110623_a() + "seed"){

                public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                    tooltip.set(0, TextFormatting.AQUA + tooltip.get(0));
                    super.func_77624_a(stack, worldIn, tooltip, flagIn);
                }
            };
            this.setSeedStack(new ItemStack((Item)seed));
            return this;
        }

        public EnumFacing selectNewDirection(World world, BlockPos pos, BlockBranch branch, GrowSignal signal) {
            return super.selectNewDirection(world, pos, branch, signal);
        }

        private EnumFacing getRelativeFace(BlockPos signalPos, BlockPos rootPos) {
            if (signalPos.func_177952_p() < rootPos.func_177952_p()) {
                return EnumFacing.NORTH;
            }
            if (signalPos.func_177952_p() > rootPos.func_177952_p()) {
                return EnumFacing.SOUTH;
            }
            if (signalPos.func_177958_n() > rootPos.func_177958_n()) {
                return EnumFacing.EAST;
            }
            if (signalPos.func_177958_n() < rootPos.func_177958_n()) {
                return EnumFacing.WEST;
            }
            return EnumFacing.UP;
        }

        protected int[] customDirectionManipulation(World world, BlockPos pos, int radius, GrowSignal signal, int[] probMap) {
            EnumFacing originDir = signal.dir.func_176734_d();
            if (pos.func_177956_o() >= signal.rootPos.func_177956_o() + this.getLowestBranchHeight() || !signal.isInTrunk()) {
                probMap[EnumFacing.UP.func_176745_a()] = 0;
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    if (!world.func_180495_p(pos.func_177972_a(dir)).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS)) continue;
                    probMap[dir.func_176746_e().func_176746_e().func_176746_e().func_176745_a()] = 0;
                    probMap[dir.func_176746_e().func_176745_a()] = 0;
                }
            }
            if (!signal.isInTrunk()) {
                EnumFacing[] sides;
                EnumFacing relativePosToRoot = this.getRelativeFace(pos, signal.rootPos);
                for (EnumFacing dir : EnumFacing.field_176754_o) {
                    probMap[dir.func_176745_a()] = 0;
                }
                for (EnumFacing dirSides : sides = new EnumFacing[]{relativePosToRoot.func_176746_e(), relativePosToRoot.func_176746_e().func_176746_e().func_176746_e(), EnumFacing.UP}) {
                    if (!world.func_175623_d(pos.func_177972_a(dirSides)) || (Integer)world.func_180495_p(pos).func_177229_b((IProperty)BlockDynamicTwilightRoots.RADIUS) <= 1) continue;
                    probMap[dirSides.func_176745_a()] = 1;
                }
                boolean isBranchUp = world.func_180495_p(pos.func_177972_a(relativePosToRoot)).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS);
                boolean isBranchSide = world.func_180495_p(pos.func_177977_b()).func_177228_b().containsKey((Object)BlockDynamicTwilightRoots.RADIUS);
                probMap[EnumFacing.DOWN.func_176745_a()] = isBranchUp && !isBranchSide ? 0 : 1;
                probMap[relativePosToRoot.func_176745_a()] = isBranchSide && !isBranchUp ? 0 : 1;
            }
            return probMap;
        }

        protected EnumFacing newDirectionSelected(EnumFacing newDir, GrowSignal signal) {
            return super.newDirectionSelected(newDir, signal);
        }
    }
}

