/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dynamictreesttf.genfeatures;

import com.ferreusveritas.dynamictrees.api.IPostGenFeature;
import com.ferreusveritas.dynamictrees.api.IPostGrowFeature;
import com.ferreusveritas.dynamictrees.blocks.BlockBranchBasic;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import twilightforest.block.BlockTFCritter;

public class FeatureGenLogCritter
implements IPostGenFeature,
IPostGrowFeature {
    public int heightLimit;
    public BlockTFCritter critterBlock;
    public int chanceRand;
    public int separationHeight;
    public int worldgenAttempts = 100;
    EnumFacing[] horizontalsDir = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};

    public FeatureGenLogCritter(int heightLim, BlockTFCritter critter, int chance, int separation) {
        this.heightLimit = heightLim;
        this.critterBlock = critter;
        this.chanceRand = chance;
        this.separationHeight = separation;
    }

    private boolean checkForOtherCrittersHorizontally(World world, BlockPos blockPos, int heightToCheck) {
        for (int i = blockPos.func_177956_o() - heightToCheck; i < blockPos.func_177956_o() + heightToCheck; ++i) {
            for (int j = 0; j < 4; ++j) {
                BlockPos pos = new BlockPos(blockPos.func_177958_n(), i, blockPos.func_177952_p());
                if (world.func_180495_p(pos.func_177972_a(this.horizontalsDir[j])).func_177230_c() != this.critterBlock) continue;
                return false;
            }
        }
        return true;
    }

    private void attemptCritterPlacing(World world, BlockPos blockPos, Random rand) {
        EnumFacing chosenDir = this.horizontalsDir[rand.nextInt(4)];
        try {
            BlockBranchBasic branch = (BlockBranchBasic)world.func_180495_p(blockPos).func_177230_c();
            if (this.checkForOtherCrittersHorizontally(world, blockPos, this.separationHeight) && world.func_175623_d(blockPos.func_177972_a(chosenDir)) && branch.getRadius(world.func_180495_p(blockPos)) >= 5) {
                world.func_175656_a(blockPos.func_177972_a(chosenDir), this.critterBlock.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)chosenDir));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean postGeneration(World world, BlockPos blockPos, Species species, Biome biome, int i, List<BlockPos> list, SafeChunkBounds safeChunkBounds, IBlockState iBlockState) {
        for (int j = 0; j < this.worldgenAttempts; ++j) {
            Random rand = new Random();
            if (rand.nextInt(this.chanceRand) != 0) continue;
            int chosenHeight = 3 + rand.nextInt(this.heightLimit - 2);
            this.attemptCritterPlacing(world, new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() + chosenHeight, blockPos.func_177952_p()), rand);
        }
        return true;
    }

    public boolean postGrow(World world, BlockPos blockPos, BlockPos blockPos1, Species species, int soilLife, boolean natural) {
        if (!natural) {
            return false;
        }
        Random rand = new Random();
        if (rand.nextInt(this.chanceRand) == 0) {
            int chosenHeight = 3 + rand.nextInt(this.heightLimit - 2);
            this.attemptCritterPlacing(world, new BlockPos(blockPos.func_177958_n(), blockPos.func_177956_o() + chosenHeight, blockPos.func_177952_p()), rand);
        }
        return true;
    }
}

