/*
 * Decompiled with CFR 0.152.
 */
package com.clownvin.livingenchantment.world.storage.loot;

import com.clownvin.livingenchantment.config.LivingConfig;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class LootInjector {
    private static LootEntry books;
    private static LootEntry armor;
    private static LootEntry uniques;

    public static void init() {
        books = new LootEntryTable(new ResourceLocation("livingenchantment:inject/living_book_loot"), 1, 3, new LootCondition[0], "living_book_loot");
        armor = new LootEntryTable(new ResourceLocation("livingenchantment:inject/unique_armor_loot"), 1, 3, new LootCondition[0], "unique_armor_loot");
        uniques = new LootEntryTable(new ResourceLocation("livingenchantment:inject/unique_weap_tool_loot"), 1, 3, new LootCondition[0], "unique_weap_tool_loot");
    }

    private static LootEntry[] createLoot(int type, int weight) {
        LootEntry[] loot;
        ResourceLocation emptyLocation = new ResourceLocation("livingenchantment:inject/empty");
        if (type == 2) {
            LootEntryTable empty = new LootEntryTable(emptyLocation, weight - 1, 0, new LootCondition[0], "empty");
            loot = new LootEntry[]{books, empty};
        } else if (LivingConfig.general.allowArmor) {
            if (type == 0) {
                LootEntryTable empty = new LootEntryTable(emptyLocation, (weight - 1) * 2, 0, new LootCondition[0], "empty");
                loot = new LootEntry[]{armor, uniques, empty};
            } else {
                LootEntryTable empty = new LootEntryTable(emptyLocation, (weight - 1) * 3, 0, new LootCondition[0], "empty");
                loot = new LootEntry[]{armor, books, uniques, empty};
            }
        } else if (type == 0) {
            LootEntryTable empty = new LootEntryTable(emptyLocation, weight - 1, 0, new LootCondition[0], "empty");
            loot = new LootEntry[]{uniques, empty};
        } else {
            LootEntryTable empty = new LootEntryTable(emptyLocation, (weight - 1) * 2, 0, new LootCondition[0], "empty");
            loot = new LootEntry[]{books, uniques, empty};
        }
        return loot;
    }

    @SubscribeEvent
    public static void loadLootEvent(LootTableLoadEvent event) {
        if (LivingConfig.loot.fishingLoot && event.getName().toString().equals("minecraft:gameplay/fishing")) {
            LootPool pool = new LootPool(LootInjector.createLoot(LivingConfig.loot.fishingLootType, LivingConfig.loot.fishingLootChance), new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "living_fishing_loot");
            event.getTable().addPool(pool);
        } else if (LivingConfig.loot.chestLoot && event.getName().toString().contains("chests/")) {
            LootPool pool = new LootPool(LootInjector.createLoot(LivingConfig.loot.chestLootType, LivingConfig.loot.chestLootChance), new LootCondition[0], new RandomValueRange(1.0f, 2.0f), new RandomValueRange(0.0f, 6.0f), "living_chest_loot");
            event.getTable().addPool(pool);
        }
    }
}

