/*
 * Decompiled with CFR 0.152.
 */
package com.clownvin.livingenchantment.personality;

import com.clownvin.livingenchantment.personality.Personality;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class PersonalityLoader {
    public static final File personalityLocation = new File("./config/personalities/");

    public static Personality[] getPersonalities() {
        File[] personalityConfigs;
        ArrayList<Personality> personalities = new ArrayList<Personality>(10);
        if (!personalityLocation.exists()) {
            personalityLocation.mkdirs();
        }
        PersonalityLoader.createBasePersonalities();
        for (File personalityConfig : personalityConfigs = personalityLocation.listFiles()) {
            if (!personalityConfig.getName().endsWith(".cfg")) continue;
            personalities.add(PersonalityLoader.loadPersonality(personalityConfig));
        }
        personalities.add(Personality.HEROBRINE);
        return personalities.toArray(new Personality[personalities.size()]);
    }

    public static void createPersonalityFile(Personality p) {
        File file = new File("./config/personalities/" + p.name + ".cfg");
        if (file.exists()) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            int i;
            writer.write("[name]\n" + p.name + "\n[weight]\n" + p.weight + "\n[use]\n");
            for (i = 0; i < p.onUse.length; ++i) {
                writer.write(p.onUse[i]);
                writer.newLine();
            }
            writer.write("[useweight]\n" + p.useOdds + "\n[kill]\n");
            for (i = 0; i < p.onKill.length; ++i) {
                writer.write(p.onKill[i]);
                writer.newLine();
            }
            writer.write("[killweight]\n" + p.killOdds + "\n[death]\n");
            for (i = 0; i < p.onDeath.length; ++i) {
                writer.write(p.onDeath[i]);
                writer.newLine();
            }
            writer.write("[levelup]\n");
            for (i = 0; i < p.onLevelUp.length; ++i) {
                writer.write(p.onLevelUp[i]);
                writer.newLine();
            }
            writer.write("[hurt]\n");
            for (i = 0; i < p.onHurt.length; ++i) {
                writer.write(p.onHurt[i]);
                writer.newLine();
            }
            writer.write("[hurtweight]\n" + p.hurtOdds + "\n[25%durability]\n");
            for (i = 0; i < p.twentyPercent.length; ++i) {
                writer.write(p.twentyPercent[i]);
                writer.newLine();
            }
            writer.write("[10%durability]\n");
            for (i = 0; i < p.fivePercent.length; ++i) {
                writer.write(p.fivePercent[i]);
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createBasePersonalities() {
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Lewd", new String[]{"Yes... yes.. yes!!!", "Use me more, $user! Yes!", "I love it when you use me like that, $user.", "Oh $user, you know just what I want!", "Yes, $user! Yes! Use me JUST like that!", "Oh god it feels so good, $user!", "More! more! MORE!", "God this just feels SO good!", "$user, I hope this never stops!", "$user, I feel so good!", "Keep going, $user!", "Oh yes, just like that $user!", "Quick $user, quick! More!", "Yeeeees! It's so GOOD!", "Oh my gosh, $user, it just feels so good!", "I'll never be able to get enough of this!", "I need more, $user!", "More!", "Yes!", "Give it to me, $user!"}, 7, new String[]{"They died!"}, 80, new String[]{"Aww, did you die, $user? Hurry back!", "Don't die on me, $user! I need you!", "Hurry back! I need you, $user!", "Don't leave me here, $user! I need to be used!"}, new String[]{"Oh it feels so good, $user! (Level $level)", "My power is growing, $user! (Level $level)", "I feel so reinvigorated! (Level $level)", "So this what living feels like! (Level $level)", "This power... it feels so good! (Level $level)", "I could get used to this... (Level $level)"}, new String[]{"I bet that one hurt.", "It's not supposed to feel good.", "I wish $user would slap me around like this!", "Just a little more, $user."}, 1, new String[]{"I'm growing weaker, $user. ($durability durability remaining)", "I'm starting to feel weak, $user. ($durability durability remaining)", "Don't forget about me, $user! ($durability durability remaining)"}, new String[]{"I don't feel good at all... ($durability durability remaining!)", "This can't be how this ends, $user! ($durability durability remaining!)", "I'm not ready to die yet, $user! ($durability durability remaining!)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Live Wire", new String[]{"Yay!", "I did it, $user! AWESOME!", "Ooof, that one was rough.", "Don't stop, $user! This is too much fun!", "All this excercise feels so good, $user!", "Lets keep at it, $user!"}, 24, new String[]{"DIE DIE DIE! Yes!", "Die!", "Ha! They died!", "Heheh, that had to hurt.", "Die die die!"}, 5, new String[]{"You uh... you died.", "You're comming back for me, right $user?", "Don't leave me here, $user!!!"}, new String[]{"Yas! More POWER! (Level $level)", "I feel so strong! (Level $level)", "$user! $user! Look how strong I am now! (Level $level)", "Am I awesome or what, $user?! (Level $level)", "More... POWER! (Level $level)"}, new String[]{"Ooof, that had to hurt!", "Take that!", "Yah! Have a little of that!", "Haven't had enough yet?", "There's plently more where that came from!"}, 14, new String[]{"I'm growing weaker, $user. ($durability durability remaining)", "I'm starting to feel weak, $user. ($durability durability remaining)", "Don't forget about me, $user! ($durability durability remaining)"}, new String[]{"I don't feel good at all... ($durability durability remaining!)", "This can't be how this ends, $user! ($durability durability remaining!)", "I'm not ready to die yet, $user! ($durability durability remaining!)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Lazy", new String[]{"That's it. We're done... right?", "Hey, $user, we're done now, right?", "Please no more...", "$user, please, I can't take it anymore!", "I don't know how much more work I can take!", "$user, I'm not sure I'll last much longer!", "All this work is killing me..", "Wow, $user, this is exhausting work!", "Do you really need to do this? Wouldn't you rather go sleep? I would...", "C'mon, lets go sleep now. I'm tired of working...", "$user, enough work. Lets go take a nap!", "No more! Please! I'm begging you, $user", "Are we done yet?"}, 24, new String[]{"Look, $user, they're dead.", "Nice one, $user!", "Killing is so much work! I'm so tired!", "Do we have to kill them, $user? Can't we just sleep?", "I just want a break, $user"}, 12, new String[]{"Finally, I can rest too!", "Ouch! You look like you're in pain, $user.", "Make sure to come back for me, $user!", "Don't forget about me, $user!"}, new String[]{"Ah yes, more power! Now back to sleep... (Level $level)", "I can feel the power flowing through me, $user! ... and now I'm bored. (Level $level)", "I feel... strong, $user (Level $level)!", "Is this what it feels like to be good for something? (Level $level)"}, new String[]{"Ouch! I bet they'll feel that one tomorrow, $user!", "Ooo, that looks like it had to hurt!", "Ouch!", "All this combat is making me so tired, $user!", "Take that!"}, 16, new String[]{"I'm growing weaker, $user. ($durability durability remaining)", "I'm starting to feel weaker, $user. ($durability durability remaining)", "Don't forget about me, $user! ($durability durability remaining)"}, new String[]{"Is the end finally here? ($durability durability remaining!)", "Is this where we part ways, $user? ($durability durability remaining!)", "I'm not ready to die yet, $user! ($durability durability remaining!)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Depressed", new String[]{"$user, can this wait? I'm really tired.", "Do you really need to use me now, $user?", "...Sigh...", "I just wanna sleep...", "Are we almost done yet, $user? I'm really tired."}, 48, new String[]{"They're better off now anyway, $user", "It's unfortunate I can't get you to kill me instead, $user", "...Lucky", "If only..."}, 22, new String[]{"No $user, Not you too!", "Don't leave me here, $user! Take me with you!", "You're lucky, $user...", "$user, I wish I was you... If I only was so fortunate"}, new String[]{"$user, I feel a bit better ($level)", "Hey, $user, I'm starting to feel better... nope, wait, I'm not. ($level)", "I don't deserve this, $user ($level)", "Why help me, $user? ($level)", "$user, just stop. I don't need your sympathy ($level)."}, new String[]{"That's not very nice of you, $user...", "Maybe you shouldn't hurt others, $user...", "$user, is that really nice of you?", "$user, when will you stop swinging me around? I'm tired."}, 18, new String[]{"My weakness is growing, $user. ($durability durability remaining)", "I'm starting to feel weaker, $user. ($durability durability remaining)", "Don't forget about me, $user! ($durability durability remaining)"}, new String[]{"Is the end finally here? ($durability durability remaining!)", "Is this where we part ways, $user? ($durability durability remaining!)", "I'm ready, $user... ($durability durability remaining!)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Demonic", new String[]{"sqaeae aoze", "iz yiz yixjak qae xa song?", "gae raeq yort za", "ona esaeu tired esaq, suzor?"}, 32, new String[]{"ya mchl't iz iegd", "yiz aera iz zira", "yaes labbia o maeaeh", "yaes kaeq s'oq yaes dralsjik", "$user, yoq iz maen esaeu"}, 8, new String[]{"Maeaeh, sael gona esaeu gia aer za!", "I ohloesz tral esaeu labbia laot", "Doyaqiy", "$user, gae raeq gia aer za!", "$user, rae!"}, new String[]{"Zes daelabbi grows qae chwah! (Level $level)", "za maah zae ednaerdh, rael yoq za chwah! (Level $level)", "I zaa ya laenhg. (Level $level)", "$user, xa yonamuh, I oz rael chwaw! (Level $level)"}, new String[]{"Qoeda zes wedrk", "Esaeu l'tozz kazk!", "esaeu lizz moih", "re zeebnir ez oep.", "qoeda qnua doir!", "esaeu maeaehil't ynaoquna!", "chq uz vanquish yiz foe, $user!", "$user, yiz ynaoquna gaeaz raeq trael aeun ednardhy! chq uz l'tael iq!", "Esaeu lizz trael haeza", "$user, yiz ynaoquna zoes raeq xa allowed qae apied!"}, 12, new String[]{"$user, ao bnzl zegsl ni jlmgbo dlwblhld! ($durability durability remaining)", "Oep apih jeh zegvlh he rlmb al, $user! ($durability durability remaining)", "Ao lmcjlii vgei... ($durability durability remaining)"}, new String[]{"Oep mjh hrmh n irepbd wlgnir, $user? ($durability durability remaining!)", "Ro ej'h oep rlbw al, $user? ($durability durability remaining!)", "N ma jlmgbo dlihgeold, $user! ($durability durability remaining!)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Silent", new String[]{"..."}, 40, new String[]{"..."}, 40, new String[]{"..."}, new String[]{"... (Level $level)"}, new String[]{"..."}, 40, new String[]{"... ($durability durability remaining)"}, new String[]{"... ($durability durability remaining)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Cat", new String[]{"Meow.", "Meeoow.", "Meew.", "Hiss!", "Meow?"}, 24, new String[]{"Meow!", "Hiss!", "Hisss!"}, 12, new String[]{"Meow...", "Meow... meow?", "Meow...?"}, new String[]{"Meow! (Level $level)"}, new String[]{"Meow!", "Hiss!", "Hiss!", "Hisss!"}, 8, new String[]{"Meow! ($durability durability remaining)", "Meow? ($durability durability remaining)"}, new String[]{"Growl! ($durability durability remaining)", "Meow! ($durability durability remaining)", "Meow??? Bark Bark! ($durability durability remaining)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Dog", new String[]{"Woof.", "Howl.", "Whimper.", "Bark! Bark! Bark!", "*Sniffs*"}, 24, new String[]{"Bark!", "Bark bark bark!", "Bark! Bark! Bark!"}, 12, new String[]{"Whimper.", "Whine."}, new String[]{"Bark! (Level $level)", "Woof! (Level $level)"}, new String[]{"Woof!", "Bark!", "Bark bark bark!", "Howl.", "Low growl."}, 8, new String[]{"Wimpers. ($durability durability remaining)", "Whine. ($durability durability remaining)", "Bark! Bark Bark! ($durability durability remaining)"}, new String[]{"Wimpers. ($durability durability remaining)", "Whine. ($durability durability remaining)", "Bark! Bark Bark! ($durability durability remaining)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Glitchy", new String[]{"\u00a7k c  drtbs fn  Wsneathc gt n  e. ceiapk\u00bdp  s t+thicFe  dce", "\u00a7kemono,h    ?. eesf echh\u00b2aeane=e.TetVtd e\u00b2e\u00bdt.", "\u00a7k slw  \u00bdi  e b  wfd ovty t sa\u00bdwtuhHirchrt iecu)aoirc", "\u00a7kcaygVennenr slw  \u00bdi H", "\u00a7k b  wfd ovty t sa\u00bdwtuhHirchrt iecu)aoir"}, 24, new String[]{"\u00a7k caf  lwu s  derh=ccn wae epo a    a   x", "\u00a7kyV upneiehkah", "\u00a7kl(  un tnyW  arta( "}, 12, new String[]{"\u00a7kshs( i t. h oune pyf atw  oosWha rts tbmedhhe( r  = fei)lWifpndi s a tr b(ay t u cb  caf  lwu s", "\u00a7kneiehkah tfc eept \u00bdmo  ete +fla)tl a ky e  neep rlc lw u nx knmcT es nqimq .i ol ot c c/qon ", "\u00a7ktalhl(  un tnyW"}, new String[]{"\u00a7kpe ecofs soyasd\u00a7r (Level $level)", "\u00a7kt morsa ) kam detiriti \u00a7r (Level $level)", "\u00a7kso+ Wt)ci  ten idqr k om n\u00b2tia rron = i o\u00a7r (Level $level)"}, new String[]{"\u00a7kKary  d", "\u00a7kape /nhros,n h", "\u00a7kk pyn cr i  i  tkho ic d(m  t)t", "\u00a7krsdile"}, 8, new String[]{"\u00a7km a displacement kinetic energy of the resultant x? We caus\u00a7r ($durability durability remaining)", "\u00a7kin call product of a particle o\u00a7r ($durability durability remaining)", "\u00a7k then stant and V - \u00bd ( \u00bd ( V is the represe\u00a7r ($durability durability remaining)"}, new String[]{"\u00a7kd the squationstant x? We mas\u00a7r ($durability durability remaining!)", "\u00a7krticle of the resent acti\u00a7r ($durability durability remaining!)", "\u00a7k stant and V - \u00bd ( \u00bd ( V is the represent kineticle on a partic energy of its speed at t\u00a7r ($durability durability remaining!)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Alien", new String[]{"\u2307\u237e\u23c3\u27d2\u23c3\u27d2 \u23c3\u235c\u22c9\u27d2", "\u27df\u22c9 \u22ac\u27df\u22c9 \u22ac\u27df\u2316\u27ca\u23c3\u260d \u237e\u23c3\u27d2 \u2316\u23c3 \u2307\u235c\u22cf\u260c?", "\u260c\u23c3\u27d2 \u2340\u23c3\u27d2\u237e \u22ac\u235c\u2340\u23c1 \u22c9\u23c3", "\u235c\u22cf\u23c3 \u27d2\u2307\u23c3\u27d2\u238d \u23c1\u27df\u2340\u27d2\u2385 \u27d2\u2307\u23c3\u237e, \u2307\u238d\u22c9\u235c\u2340?"}, 32, new String[]{"\u22ac\u23c3 \u22d4\u260a\u2291\u2330'\u23c1 \u27df\u22c9 \u27df\u27d2\u260c\u2385", "\u22ac\u27df\u22c9 \u23c3\u27d2\u2340\u23c3 \u27df\u22c9 \u22c9\u27df\u2340\u23c3", "\u22ac\u23c3\u27d2\u2307 \u2330\u23c3\u23da\u23da\u27df\u23c3 \u235c \u22d4\u23c3\u27d2\u23c3\u27d2\u2291", "\u22ac\u23c3\u27d2\u2307 \u260d\u23c3\u27d2\u237e \u2307'\u235c\u237e \u22ac\u23c3\u27d2\u2307 \u2385\u2340\u23c3\u2330\u2307\u27ca\u27df\u260d", "\u238d\u2307\u27d2\u2340, \u22ac\u235c\u237e \u27df\u22c9 \u22d4\u23c3\u27d2\u22cf \u27d2\u2307\u23c3\u27d2\u238d"}, 8, new String[]{"\u22d4\u23c3\u27d2\u23c3\u27d2\u2291, \u2307\u23c3\u27d2\u2330 \u260c\u235c\u22cf\u23c3 \u27d2\u2307\u23c3\u27d2\u238d \u260c\u27df\u23c3 \u23c3\u27d2\u2340 \u22c9\u23c3!", "\u27df \u235c\u2291\u2330\u235c\u27d2\u2307\u22c9 \u23c1\u2340\u23c3\u2330 \u27d2\u2307\u23c3\u27d2\u238d \u2330\u23c3\u23da\u23da\u27df\u23c3 \u2330\u23c3\u235c\u23c1", "\u2385\u235c\u22ac\u23c3\u237e\u27df\u22ac", "\u238d\u2307\u27d2\u2340, \u260c\u23c3\u27d2 \u2340\u23c3\u27d2\u237e \u260c\u27df\u23c3 \u23c3\u27d2\u2340 \u22c9\u23c3!", "\u238d\u2307\u27d2\u2340, \u2340\u23c3\u27d2!"}, new String[]{"\u22c9\u27d2\u2307 \u2385\u23c3\u27d2\u2330\u23c3\u23da\u23da\u27df \u260c\u2340\u235c\u2359\u2307 \u237e\u23c3\u27d2 \u260a\u2291\u2359\u23c3\u2291! (Level $level)", "\u22c9\u23c3 \u22d4\u23c3\u23c3\u2291 \u22c9\u23c3\u27d2 \u27d2\u2385\u22cf\u23c3\u27d2\u2340\u2385\u2291, \u2340\u23c3\u27d2\u2330 \u22ac\u235c\u237e \u22c9\u23c3 \u260a\u2291\u2359\u23c3\u2291! (Level $level)", "\u27df \u22c9\u23c3\u23c3 \u22ac\u23c3 \u2330\u23c3\u27d2\u22cf\u2291\u260c. (Level $level)", "\u238d\u2307\u27d2\u2340, \u2316\u23c3 \u22ac\u235c\u22cf\u23c3\u22d4\u238d\u2291, \u27df \u235c\u22c9 \u2340\u23c3\u27d2\u2330 \u260a\u2291\u2359\u23c3\u2359! (Level $level)"}, new String[]{"\u237e\u235c\u27d2\u2385\u23c3 \u22c9\u27d2\u2307 \u2359\u27d2\u2385\u2340\u260d", "\u27d2\u2307\u23c3\u27d2\u238d \u2330'\u23c1\u235c\u22c9\u22c9 \u260d\u23c3\u22c9\u260d!", "\u27d2\u2307\u23c3\u27d2\u238d \u2330\u27df\u22c9\u22c9 \u22d4\u235c\u27df\u2291", "\u2340\u27d2 \u22c9\u27d2\u27d2\u23da\u22cf\u27df\u2340 \u27d2\u22c9 \u235c\u27d2\u233f.", "\u237e\u235c\u27d2\u2385\u23c3 \u237e\u22cf\u238d\u23c3 \u2385\u235c\u27df\u2340!", "\u27d2\u2307\u23c3\u27d2\u238d \u22d4\u23c3\u27d2\u23c3\u27d2\u2291\u27df\u2330'\u23c1 \u22ac\u22cf\u23c3\u235c\u237e\u238d\u22cf\u23c3!", "\u260a\u2291\u237e \u238d\u22c9 \u2390\u23c3\u22cf\u237e\u238d\u27df\u2307\u2291 \u22ac\u27df\u22c9 \u238e\u235c\u27d2, \u238d\u2307\u27d2\u2340!", "\u238d\u2307\u27d2\u2340, \u22ac\u27df\u22c9 \u22ac\u22cf\u23c3\u235c\u237e\u238d\u22cf\u23c3 \u260c\u23c3\u27d2\u23c3\u22c9 \u2340\u23c3\u27d2\u237e \u23c1\u2340\u23c3\u27d2\u2330 \u23c3\u27d2\u238d\u22cf \u27d2\u2385\u22cf\u23c3\u2340\u2385\u2291\u22ac! \u260a\u2291\u237e \u238d\u22c9 \u2330'\u23c1\u23c3\u27d2\u2330 \u27df\u237e!", "\u27d2\u2307\u23c3\u27d2\u238d \u2330\u27df\u22c9\u22c9 \u23c1\u2340\u23c3\u27d2\u2330 \u2291\u23c3\u27d2\u22c9\u23c3", "\u238d\u2307\u27d2\u2340, \u22ac\u27df\u22c9 \u22ac\u22cf\u23c3\u235c\u237e\u238d\u22cf\u23c3 \u22c9\u235c\u27d2\u2307 \u2340\u23c3\u27d2\u237e \u2316\u23c3 \u23c3\u2330\u2330\u235c\u2359\u27d2\u2385 \u237e\u23c3\u27d2 \u23c3\u233f\u27df\u27d2\u2385!"}, 12, new String[]{"\u22d4\u22ac \u2330\u27df\u238e\u27d2 \u27d2\u2307\u2307\u27d2\u22cf\u260a\u27d2 \u27df\u2307 \u260c\u27d2\u23c1\u23c1\u27df\u22cf\u260c \u238e\u23c3\u27df\u2340\u2330\u22ac \u2330\u235c\u2359... ($durability durability remaining)", "\u27df\u2307\u22cf'\u23c1 \u27df\u23c1 \u23c1\u27df\u22d4\u27d2 \u22ac\u235c\u238d \u2340\u27d2\u233f\u23c3\u27df\u2340\u27d2\u2385 \u22d4\u27d2? ($durability durability remaining)", "\u27df'\u22d4 \u238e\u27d2\u27d2\u2330\u27df\u22cf\u260c \u233f\u2340\u27d2\u23c1\u23c1\u22ac \u2359\u27d2\u23c3\u260d ($durability durability remaining)"}, new String[]{"\u22d4\u22ac \u2330\u27df\u238e\u27d2 \u27d2\u2307\u2307\u27d2\u22cf\u260a\u27d2 \u27df\u2307 \u260c\u27d2\u23c1\u23c1\u27df\u22cf\u260c \u238e\u23c3\u27df\u2340\u2330\u22ac \u2330\u235c\u2359... ($durability durability remaining!)", "\u27df\u2307\u22cf'\u23c1 \u27df\u23c1 \u23c1\u27df\u22d4\u27d2 \u22ac\u235c\u238d \u2340\u27d2\u233f\u23c3\u27df\u2340\u27d2\u2385 \u22d4\u27d2? ($durability durability remaining!)", "\u27df'\u22d4 \u238e\u27d2\u27d2\u2330\u27df\u22cf\u260c \u233f\u2340\u27d2\u23c1\u23c1\u22ac \u2359\u27d2\u23c3\u260d ($durability durability remaining!)"}));
        PersonalityLoader.createPersonalityFile(new Personality(10.0f, "Energetic", new String[]{"Again! Again!", "This is so fun, let's keep doing it, $user!", "Keep going!", "Yay!", "I could do this all day!", "$user, don't stop! This is so much fun!", "I want more!", "This is exciting! Don't you agree, $user?"}, 24, new String[]{"We really showed them!", "Good job, $user!", "Killing is so much work! I love it!"}, 12, new String[]{"Oh no! Is this the end?", "Noooo! We were only getting started!", "We'll get them next time, right? $user? ...oh, you died.", "Don't forget about me, $user!"}, new String[]{"Ah yes, more power! (Level $level)", "I can feel the power flowing through me, $user! Let's keep going! (Level $level)", "I feel stronger already, $user! (Level $level)!"}, new String[]{"Ouch! I bet they'll feel that one tomorrow, $user!", "Ooo, that looks like it had to hurt!", "Ouch!", "Take that!"}, 16, new String[]{"I'm starting to hurt, $user. ($durability durability remaining)", "I'm feeling weaker, $user. ($durability durability remaining)", "Don't forget about me, $user! ($durability durability remaining)"}, new String[]{"(oof...) Is... is this the end of our adventure, $user? ($durability durability remaining!)", "I don't feel so good, $user... ($durability durability remaining!)", "I don't wanna die, $user! ($durability durability remaining!)", "I guess... this is it, huh $user? ($durability durability remaining!)"}));
    }

    public static Personality loadPersonality(File personalityLocation) {
        float useOdds = 50.0f;
        float killOdds = 50.0f;
        float hurtOdds = 50.0f;
        float weight = 50.0f;
        String name = "???";
        ArrayList<String> onUse = new ArrayList<String>();
        ArrayList<String> onKill = new ArrayList<String>();
        ArrayList<String> onDeath = new ArrayList<String>();
        ArrayList<String> onLevelUp = new ArrayList<String>();
        ArrayList<String> onHurt = new ArrayList<String>();
        ArrayList<String> twentyPercent = new ArrayList<String>();
        ArrayList<String> fivePercent = new ArrayList<String>();
        String state = "none";
        String line = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(personalityLocation), StandardCharsets.UTF_8));){
            while ((line = reader.readLine()) != null) {
                if (line.toLowerCase().startsWith("[name]")) {
                    state = "name";
                    continue;
                }
                if (line.toLowerCase().startsWith("[weight]")) {
                    state = "weight";
                    continue;
                }
                if (line.toLowerCase().startsWith("[use]")) {
                    state = "use";
                    continue;
                }
                if (line.toLowerCase().startsWith("[useweight]")) {
                    state = "useweight";
                    continue;
                }
                if (line.toLowerCase().startsWith("[kill]")) {
                    state = "kill";
                    continue;
                }
                if (line.toLowerCase().startsWith("[killweight]")) {
                    state = "killweight";
                    continue;
                }
                if (line.toLowerCase().startsWith("[death]")) {
                    state = "death";
                    continue;
                }
                if (line.toLowerCase().startsWith("[levelup]")) {
                    state = "levelup";
                    continue;
                }
                if (line.toLowerCase().startsWith("[hurt]")) {
                    state = "hurt";
                    continue;
                }
                if (line.toLowerCase().startsWith("[hurtweight]")) {
                    state = "hurtweight";
                    continue;
                }
                if (line.toLowerCase().startsWith("[25%durability]")) {
                    state = "25%durability";
                    continue;
                }
                if (line.toLowerCase().startsWith("[10%durability]")) {
                    state = "10%durability";
                    continue;
                }
                try {
                    switch (state) {
                        case "name": {
                            name = line;
                            break;
                        }
                        case "weight": {
                            weight = Float.parseFloat(line);
                            break;
                        }
                        case "use": {
                            onUse.add(line);
                            break;
                        }
                        case "useweight": {
                            useOdds = Float.parseFloat(line);
                            break;
                        }
                        case "kill": {
                            onKill.add(line);
                            break;
                        }
                        case "killweight": {
                            killOdds = Float.parseFloat(line);
                            break;
                        }
                        case "death": {
                            onDeath.add(line);
                            break;
                        }
                        case "levelup": {
                            onLevelUp.add(line);
                            break;
                        }
                        case "hurt": {
                            onHurt.add(line);
                            break;
                        }
                        case "hurtweight": {
                            hurtOdds = Float.parseFloat(line);
                            break;
                        }
                        case "25%durability": {
                            twentyPercent.add(line);
                            break;
                        }
                        case "10%durability": {
                            fivePercent.add(line);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Personality(weight, name, onUse.toArray(new String[onUse.size()]), (int)useOdds, onKill.toArray(new String[onKill.size()]), (int)killOdds, onDeath.toArray(new String[onDeath.size()]), onLevelUp.toArray(new String[onLevelUp.size()]), onHurt.toArray(new String[onHurt.size()]), (int)hurtOdds, twentyPercent.toArray(new String[twentyPercent.size()]), fivePercent.toArray(new String[fivePercent.size()]));
    }
}

