/*
 * Decompiled with CFR 0.152.
 */
package com.clownvin.livingenchantment.personality;

import com.clownvin.livingenchantment.personality.PersonalityLoader;
import com.clownvin.util.Weighted;
import com.clownvin.util.WeightedList;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber
public class Personality
extends IForgeRegistryEntry.Impl<Personality>
implements Weighted {
    public static Personality HEROBRINE;
    private static final WeightedList<Personality> weightedPersonalityList;
    private static IForgeRegistry<Personality> registry;
    public final int useOdds;
    public final int killOdds;
    public final int hurtOdds;
    public final float weight;
    public final String name;
    public final String[] onUse;
    public final String[] onKill;
    public final String[] onDeath;
    public final String[] onLevelUp;
    public final String[] onHurt;
    public final String[] twentyPercent;
    public final String[] fivePercent;

    public Personality(float weight, String name, String[] onUse, int useOdds, String[] onKill, int killOdds, String[] onDeath, String[] onLevelUp, String[] onHurt, int hurtOdds, String[] twentyPercent, String[] fivePercent) {
        this.setRegistryName("livingenchantment", name.toLowerCase());
        this.name = name;
        this.onUse = onUse;
        this.useOdds = useOdds;
        this.onKill = onKill;
        this.killOdds = killOdds;
        this.onDeath = onDeath;
        this.onLevelUp = onLevelUp;
        this.onHurt = onHurt;
        this.hurtOdds = hurtOdds;
        this.weight = weight;
        this.twentyPercent = twentyPercent;
        this.fivePercent = fivePercent;
    }

    @SubscribeEvent
    public static void createRegistry(RegistryEvent.NewRegistry event) {
        RegistryBuilder builder = new RegistryBuilder();
        registry = builder.setName(new ResourceLocation("livingenchantment", "personalityRegistry")).setType(Personality.class).create();
    }

    @SubscribeEvent
    public static void registerPersonalities(RegistryEvent.Register<Personality> event) {
        Personality[] personalityList;
        for (Personality p : personalityList = PersonalityLoader.getPersonalities()) {
            event.getRegistry().register((IForgeRegistryEntry)p);
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Personality[0]);
    }

    public static void fillWeightedList() {
        int i = 0;
        for (Personality p : registry.getValuesCollection()) {
            if (p.getWeight() <= 0.0f) continue;
            weightedPersonalityList.add(p);
            ++i;
        }
        System.out.println("Filled weighted personality list with " + i + " personalities.");
    }

    @Nullable
    public static Personality getPersonality(ResourceLocation location) {
        return (Personality)registry.getValue(location);
    }

    public static ResourceLocation getKey(Personality personality) {
        return registry.getKey((IForgeRegistryEntry)personality);
    }

    public static synchronized IForgeRegistry<Personality> getRegistry() {
        return registry;
    }

    private static Personality getPersonality(float personality) {
        if (weightedPersonalityList.size() == 0) {
            return HEROBRINE;
        }
        return weightedPersonalityList.get(personality);
    }

    public static Personality getPersonality(NBTTagCompound tag) {
        float f = tag.func_74760_g("personality");
        while (f <= 0.0f || f > 1.0f) {
            f = (float)Math.random();
        }
        tag.func_74776_a("personality", f);
        return Personality.getPersonality(f);
    }

    public static Personality getPersonality(String personality) {
        return (Personality)registry.getValue(new ResourceLocation(personality.toLowerCase()));
    }

    public static float getValue(Personality personality) {
        return weightedPersonalityList.getVal(personality);
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    private String getRandomPhrase(String[] phrases) {
        if (phrases == null) {
            throw new RuntimeException("phrases does not exist");
        }
        if (phrases.length == 0) {
            throw new RuntimeException("phrases length is 0");
        }
        return phrases[(int)(Math.random() * (double)phrases.length)];
    }

    public String getTwentyPercent() {
        return this.getRandomPhrase(this.twentyPercent);
    }

    public String getFivePercent() {
        return this.getRandomPhrase(this.fivePercent);
    }

    public String getOnTargetHurt() {
        return this.getRandomPhrase(this.onHurt);
    }

    public String getOnUse() {
        return this.getRandomPhrase(this.onUse);
    }

    public String getOnKill() {
        return this.getRandomPhrase(this.onKill);
    }

    public String getOnDeath() {
        return this.getRandomPhrase(this.onDeath);
    }

    public String getOnLevelUp() {
        return this.getRandomPhrase(this.onLevelUp);
    }

    public String toString() {
        return this.getRegistryName().toString();
    }

    static {
        weightedPersonalityList = new WeightedList();
    }
}

