/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.totemexpansion.handler.ticker;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import party.lemons.totemexpansion.handler.ticker.ITicker;
import party.lemons.totemexpansion.handler.ticker.TickerSavedData;

@Mod.EventBusSubscriber(modid="totemexpansion")
public class TickerHandler {
    private static List<ITicker> tickers = new ArrayList<ITicker>();
    private static List<Class<ITicker>> registeredTickers = new ArrayList<Class<ITicker>>();

    public static void addTicker(ITicker ticker) {
        tickers.removeIf(t -> t.getClass() == ticker.getClass());
        tickers.add(ticker);
    }

    private static void removeFinishedTickers(World world) {
        tickers.removeIf(t -> t.isTaskFinished(world));
    }

    private static void tick(World world) {
        tickers.forEach(t -> t.update(world));
    }

    public static <T extends ITicker> void registerTicker(Class<T> clazz) {
        registeredTickers.add(clazz);
    }

    public static NBTTagList writeToNBT() {
        NBTTagList list = new NBTTagList();
        for (ITicker ticker : tickers) {
            NBTTagCompound tickerTags = ticker.writeToNBT();
            tickerTags.func_74768_a("key", registeredTickers.indexOf(ticker.getClass()));
            list.func_74742_a((NBTBase)tickerTags);
        }
        return list;
    }

    public static void readFromNBT(NBTTagList tickerList) {
        World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
        for (int i = 0; i < tickerList.func_74745_c(); ++i) {
            NBTTagCompound tag = tickerList.func_150305_b(i);
            Class<ITicker> clazz = registeredTickers.get(tag.func_74762_e("key"));
            try {
                ITicker ticker = clazz.getConstructor(World.class).newInstance(world);
                ticker.readFromNBT(tag);
                TickerHandler.addTicker(ticker);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.world.field_73011_w.getDimension() != 0) {
            return;
        }
        TickerHandler.tick(event.world);
        TickerHandler.removeFinishedTickers(event.world);
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_175693_T().func_75742_a(TickerSavedData.class, "totemexpansion_TickerData");
    }
}

