/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.totemexpansion.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import party.lemons.totemexpansion.handler.action.ActionState;
import party.lemons.totemexpansion.handler.action.PlayerAction;

public interface PlayerData {
    @CapabilityInject(value=PlayerData.class)
    public static final Capability<PlayerData> CAPABILITY = null;

    public ActionState getActionState();

    public void setActionState(EntityPlayer var1, ActionState var2);

    public void setActionStateFromLoad(ActionState var1);

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        private PlayerData instance = (PlayerData)CAPABILITY.getDefaultInstance();

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CAPABILITY;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == CAPABILITY ? CAPABILITY.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return CAPABILITY.getStorage().writeNBT(CAPABILITY, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            CAPABILITY.getStorage().readNBT(CAPABILITY, (Object)this.instance, null, nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<PlayerData> {
        @Nullable
        public NBTBase writeNBT(Capability<PlayerData> capability, PlayerData instance, EnumFacing side) {
            NBTTagCompound tags = new NBTTagCompound();
            tags.func_74782_a("action", (NBTBase)instance.getActionState().writeToNBT());
            return tags;
        }

        public void readNBT(Capability<PlayerData> capability, PlayerData instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tags = (NBTTagCompound)nbt;
            NBTTagCompound actionTags = (NBTTagCompound)tags.func_74781_a("action");
            ActionState state = new ActionState(actionTags);
            if (state.getAction() != null) {
                instance.setActionStateFromLoad(state);
            }
        }
    }

    public static class Impl
    implements PlayerData {
        private ActionState actionState = new ActionState(PlayerAction.NONE);

        @Override
        public ActionState getActionState() {
            return this.actionState;
        }

        @Override
        public void setActionState(EntityPlayer player, ActionState state) {
            this.actionState.getAction().onActionEnd(player, this.actionState);
            this.actionState = state;
            this.actionState.getAction().onActionStart(player, this.actionState);
        }

        @Override
        public void setActionStateFromLoad(ActionState state) {
            this.actionState = state;
        }
    }
}

