/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.util;

import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.daveyx0.multimob.core.MMEntityRegistry;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.capabilities.Capability;

public class EntityUtil {
    public static Predicate<Entity> isNotPlayer() {
        return p -> !(p instanceof EntityPlayer);
    }

    public static String getBlockStateName(IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        return stack.func_82833_r();
    }

    public static void removeWhenDisabled(Entity entity) {
        if (MMEntityRegistry.entities.containsKey(entity.getClass()) && !MMEntityRegistry.entities.get(entity.getClass()).booleanValue()) {
            entity.func_70106_y();
        }
    }

    @Nullable
    public static EntityLivingBase getLoadedEntityByUUID(UUID uuid, World world) {
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            Entity entity = (Entity)world.field_72996_f.get(i);
            if (!uuid.equals(entity.func_110124_au())) continue;
            if (entity instanceof EntityLivingBase) {
                return (EntityLivingBase)entity;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static ItemStack getCustomLootItem(Entity entityIn, ResourceLocation resourceLootTable, ItemStack defaultItem) {
        LootContext.Builder lootcontext$builder;
        LootTable loottable;
        Iterator iterator;
        if (resourceLootTable != null && (iterator = (loottable = entityIn.field_70170_p.func_184146_ak().func_186521_a(resourceLootTable)).func_186462_a(entityIn.func_130014_f_().field_73012_v, (lootcontext$builder = new LootContext.Builder((WorldServer)entityIn.field_70170_p).func_186472_a(entityIn)).func_186471_a()).iterator()).hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            return itemstack;
        }
        return defaultItem;
    }

    @Nullable
    public static <T> T getCapability(@Nullable Entity entity, Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(entity != null && entity.hasCapability(capability, facing) ? entity.getCapability(capability, facing) : null);
    }

    @Nullable
    public static ItemStack[] getCustomLootItems(Entity entityIn, ResourceLocation resourceLootTable, ItemStack defaultItem) {
        ItemStack[] arrayOfItems = null;
        if (resourceLootTable != null) {
            LootTable loottable = entityIn.field_70170_p.func_184146_ak().func_186521_a(resourceLootTable);
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)entityIn.field_70170_p).func_186472_a(entityIn);
            List listOfItems = loottable.func_186462_a(entityIn.func_130014_f_().field_73012_v, lootcontext$builder.func_186471_a());
            arrayOfItems = new ItemStack[listOfItems.size()];
            int i = 0;
            Iterator iterator = listOfItems.iterator();
            while (iterator.hasNext()) {
                ItemStack itemstack;
                arrayOfItems[i] = itemstack = (ItemStack)iterator.next();
                ++i;
            }
        }
        if (arrayOfItems == null) {
            arrayOfItems = new ItemStack[]{defaultItem};
        }
        return arrayOfItems;
    }

    public static boolean isValidMobLightLevel(EntityLivingBase entity) {
        BlockPos blockpos = new BlockPos(entity.field_70165_t, entity.func_174813_aQ().field_72338_b, entity.field_70161_v);
        if (entity.func_130014_f_().func_175642_b(EnumSkyBlock.SKY, blockpos) > entity.func_70681_au().nextInt(32)) {
            return false;
        }
        int i = entity.func_130014_f_().func_175671_l(blockpos);
        if (entity.func_130014_f_().func_72911_I()) {
            int j = entity.func_130014_f_().func_175657_ab();
            entity.func_130014_f_().func_175692_b(10);
            i = entity.func_130014_f_().func_175671_l(blockpos);
            entity.func_130014_f_().func_175692_b(j);
        }
        return i <= entity.func_70681_au().nextInt(8);
    }

    public static float distanceToSurface(EntityLivingBase entityLivingBase, World world) {
        int k;
        int j;
        int i = MathHelper.func_76128_c((double)entityLivingBase.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76128_c((double)entityLivingBase.func_174813_aQ().field_72338_b), k = MathHelper.func_76128_c((double)entityLivingBase.field_70161_v));
        IBlockState l = world.func_180495_p(pos);
        if (l != null && l.func_185904_a() == Material.field_151586_h) {
            for (int j1 = 1; j1 < 64; ++j1) {
                BlockPos pos1 = new BlockPos(i, j + j1, k);
                IBlockState i1 = world.func_180495_p(pos1);
                if (i1.func_177230_c() != Blocks.field_150350_a && i1.func_185904_a() == Material.field_151586_h) continue;
                return j1;
            }
        }
        return -1.0f;
    }

    public static Object[] searchTree(Entity entity, double d) {
        Object[] states = new Object[3];
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(entity.field_70165_t - d, entity.field_70163_u - d, entity.field_70161_v - d, entity.field_70165_t + d, entity.field_70163_u + d, entity.field_70161_v + d);
        int n = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int o = MathHelper.func_76128_c((double)axisalignedbb.field_72336_d);
        int p = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int q = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int r = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int s = MathHelper.func_76128_c((double)axisalignedbb.field_72334_f);
        for (int p1 = n; p1 < o; ++p1) {
            for (int q1 = p; q1 < q; ++q1) {
                for (int n2 = r; n2 < s; ++n2) {
                    BlockPos pos = new BlockPos(p1, q1, n2);
                    IBlockState state = entity.func_130014_f_().func_180495_p(pos);
                    if (state == null || state.func_177230_c() == Blocks.field_150350_a || state == null || !(state.func_177230_c() instanceof BlockLog) && (state.func_185904_a() != Material.field_151575_d || !(state.func_177230_c() instanceof BlockRotatedPillar)) && (state.func_185904_a() != Material.field_151575_d || !state.func_177230_c().canSustainLeaves(state, (IBlockAccess)entity.func_130014_f_(), pos))) continue;
                    states[0] = state.func_177230_c().func_176203_a(state.func_177230_c().func_180651_a(state));
                    for (int l = 0; l < 64; ++l) {
                        BlockPos pos2 = new BlockPos(p1, q1 + l, n2);
                        IBlockState state2 = entity.func_130014_f_().func_180495_p(pos2);
                        if (state2 == null || state2.func_177230_c() == Blocks.field_150350_a || state2 == null || !(state2.func_177230_c() instanceof BlockLeaves) && state2.func_185904_a() != Material.field_151584_j) continue;
                        states[1] = state2;
                        states[2] = pos2;
                        return states;
                    }
                }
            }
        }
        return null;
    }

    protected void writePos(BlockPos pos, ByteBuf buf) {
        buf.writeInt(pos.func_177958_n());
        buf.writeInt(pos.func_177956_o());
        buf.writeInt(pos.func_177952_p());
    }

    protected BlockPos readPos(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        return new BlockPos(x, y, z);
    }
}

