/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.daveyx0.multimob.util.ImageUtil;
import net.daveyx0.multimob.util.ResourceLocationUtil;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ColorUtil {
    public static int[] getBlockStateColor(IBlockState state, @Nullable BlockPos pos, @Nullable World worldObj, boolean useExtendedState) {
        return ColorUtil.getBlockStateColor(state, pos, worldObj, EnumFacing.UP, useExtendedState);
    }

    public static int[] getBlockStateColor(IBlockState state, @Nullable BlockPos pos, @Nullable World worldObj, EnumFacing face, boolean useExtendedState) {
        String textureName;
        int[] color = new int[3];
        int colorMultiplier = -1;
        IBlockState backupState = state;
        if (useExtendedState) {
            state = state.func_177230_c().getExtendedState(state, (IBlockAccess)worldObj, pos);
        }
        colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)worldObj, pos, 0);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        if (sprite != null && (textureName = sprite.func_94215_i()).equals("missingno")) {
            state = backupState;
            colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)worldObj, pos, 0);
            sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        }
        if (state.func_177230_c() != Blocks.field_150350_a) {
            MapColor mapcolor;
            Color colour = new Color(colorMultiplier, true);
            if (colorMultiplier != -1 && (colour.getRed() != colour.getGreen() || colour.getGreen() != colour.getBlue() || colour.getBlue() != colour.getRed()) && state.func_177230_c() != Blocks.field_150398_cm) {
                color[0] = colour.getRed();
                color[1] = colour.getGreen();
                color[2] = colour.getBlue();
            } else if (sprite != null) {
                List quads;
                IBakedModel bakedModel;
                String textureName2 = sprite.func_94215_i();
                String modelName = textureName2.replaceAll(":", ":models/");
                ModelResourceLocation model = new ModelResourceLocation(modelName);
                String topTextureName = "";
                if (!(model == null || (bakedModel = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state)) == null || Loader.isModLoaded((String)"codechickenlib") || Loader.isModLoaded((String)"botania") || (quads = bakedModel.func_188616_a(state, face, 1L)) == null || quads.isEmpty() || quads.size() <= 0)) {
                    topTextureName = ((BakedQuad)quads.get(0)).func_187508_a().func_94215_i();
                }
                if (!topTextureName.equals("") && !topTextureName.equals("missingno")) {
                    color = ColorUtil.getTextureColor(topTextureName, "blocks");
                } else if (!textureName2.equals("") && !textureName2.equals("missingno")) {
                    color = ColorUtil.getTextureColor(textureName2, "blocks");
                }
            }
            if (color == null && colorMultiplier == -1 && (mapcolor = state.func_185909_g((IBlockAccess)worldObj, pos)) != null) {
                colorMultiplier = mapcolor.field_76291_p;
            }
        }
        if (ColorUtil.isColorInvalid(color) && useExtendedState) {
            color = ColorUtil.getBlockStateColor(state, pos, worldObj, face, false);
        }
        return color;
    }

    public static int[] getItemStackColor(ItemStack stack, World worldObj) {
        int[] color = new int[3];
        int colorMultiplier = -1;
        colorMultiplier = Minecraft.func_71410_x().getItemColors().func_186728_a(stack, 0);
        if (colorMultiplier != -1) {
            Color colour = new Color(colorMultiplier, true);
            color[0] = colour.getRed();
            color[1] = colour.getGreen();
            color[2] = colour.getBlue();
        } else {
            String textureName = "";
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, worldObj, null);
            List quads = model.func_188616_a(null, null, 1L);
            if (quads != null && !quads.isEmpty() && quads.size() > 0) {
                textureName = ((BakedQuad)quads.get(0)).func_187508_a().func_94215_i();
            }
            if (!textureName.equals("") && !textureName.equals("missingno")) {
                color = ColorUtil.getTextureColor(textureName, "items");
            }
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getTextureColor(String name, String type) {
        int[] rgb = null;
        IResource resource = ColorUtil.getResource(name, type);
        if (resource != null) {
            InputStream stream = resource.func_110527_b();
            try {
                rgb = ImageUtil.main(stream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rgb;
    }

    public static IResource getResource(String name, String type) {
        SimpleReloadableResourceManager resourceManager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        Set set = resourceManager.func_135055_a();
        Object[] domains = set.toArray();
        IResource resource = null;
        if (name.contains(":")) {
            String[] divided = name.split(":");
            if (divided != null && divided.length > 0) {
                resource = ResourceLocationUtil.getResource(divided[0].toString(), "textures/" + divided[1] + ".png");
            }
        } else {
            for (int i = 0; i < domains.length && (resource = ResourceLocationUtil.getResource(domains[i].toString(), "textures/" + type + "/" + name + ".png")) == null; ++i) {
            }
        }
        return resource;
    }

    public static int[] setBrightness(int[] rgb, float brightness) {
        float newBrightness;
        float newRed = (float)rgb[0] / 255.0f;
        float newGreen = (float)rgb[1] / 255.0f;
        float newBlue = (float)rgb[2] / 255.0f;
        if (brightness < 0.0f) {
            newBrightness = brightness * -1.0f;
            newBrightness = 1.0f - newBrightness / 100.0f;
            newRed *= newBrightness;
            newGreen *= newBrightness;
            newBlue *= newBrightness;
        } else if (brightness > 0.0f) {
            newBrightness = brightness;
            float tempRed = (1.0f - newRed) * (newBrightness /= 100.0f);
            float tempGreen = (1.0f - newGreen) * newBrightness;
            float tempBlue = (1.0f - newBlue) * newBrightness;
            newRed += tempRed;
            newGreen += tempGreen;
            newBlue += tempBlue;
        }
        if (newRed > 1.0f) {
            newRed = 1.0f;
        }
        if (newGreen > 1.0f) {
            newGreen = 1.0f;
        }
        if (newBlue > 1.0f) {
            newBlue = 1.0f;
        }
        int[] newColor = new int[]{Math.round(newRed * 255.0f), Math.round(newGreen * 255.0f), Math.round(newBlue * 255.0f)};
        return newColor;
    }

    public static int getBlockColor(Entity entity) {
        int[] newColor;
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (entity.func_130014_f_().func_180495_p(new BlockPos(i, j, k)).func_177230_c() == Blocks.field_150350_a) {
            j = MathHelper.func_76128_c((double)(entity.func_174813_aQ().field_72338_b - 0.1));
        }
        BlockPos pos = new BlockPos(i, j, k);
        IBlockState state = entity.func_130014_f_().func_180495_p(pos);
        int colorMultiplier = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)entity.func_130014_f_(), pos, 0);
        if (state.func_177230_c() != Blocks.field_150350_a && (newColor = ColorUtil.getBlockStateColor(state, pos, entity.func_130014_f_(), false)) != null) {
            Color color = new Color(newColor[0], newColor[1], newColor[2]);
            return color.hashCode();
        }
        return -1;
    }

    public static IBlockState getBlockState(Entity entity) {
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        int j = MathHelper.func_76128_c((double)entity.func_174813_aQ().field_72338_b);
        int k = MathHelper.func_76128_c((double)entity.field_70161_v);
        if (entity.func_130014_f_().func_180495_p(new BlockPos(i, j, k)).func_177230_c() == Blocks.field_150350_a) {
            j = MathHelper.func_76128_c((double)(entity.func_174813_aQ().field_72338_b - 0.1));
        }
        BlockPos pos = new BlockPos(i, j, k);
        IBlockState state = entity.func_130014_f_().func_180495_p(pos);
        return state;
    }

    @Nullable
    public static ResourceLocation convertToGreyScale(ResourceLocation resource) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
        ResourceLocation greyscaleTexture = null;
        try {
            BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resourceManager.func_110536_a(resource).func_110527_b());
            BufferedImage greyBufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 11);
            Graphics g = greyBufferedImage.getGraphics();
            g.drawImage(greyBufferedImage, 0, 0, null);
            g.dispose();
            greyscaleTexture = new ResourceLocation(resource.func_110624_b(), resource.func_110623_a());
            Minecraft.func_71410_x().func_110434_K().func_110579_a(greyscaleTexture, (ITextureObject)new DynamicTexture(greyBufferedImage));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return greyscaleTexture;
    }

    public static boolean isColorInvalid(int[] color) {
        return color == null || color.length == 0 || color[0] == 0 && color[1] == 0 && color[2] == 0;
    }
}

