/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.spawn;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.daveyx0.multimob.config.MMConfigSpawns;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.eventhandler.Event;

public class MMWorldSpawner {
    private static final int MOB_COUNT_DIV = (int)Math.pow(17.0, 2.0);
    private final Set<ChunkPos> eligibleChunksForSpawning = Sets.newHashSet();

    public int findChunksForSpawning(WorldServer worldServerIn, boolean spawnHostileMobs, boolean spawnPeacefulMobs, boolean spawnOnSetTickRate) {
        int i;
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return 0;
        }
        int[] dimensionWhiteList = MMConfigSpawns.getDimensionWhiteList();
        boolean check = false;
        if (dimensionWhiteList != null && dimensionWhiteList.length != 0) {
            for (i = 0; i < dimensionWhiteList.length; ++i) {
                if (dimensionWhiteList[i] != worldServerIn.field_73011_w.getDimension()) continue;
                check = true;
            }
        }
        if (!check) {
            return 0;
        }
        this.eligibleChunksForSpawning.clear();
        i = 0;
        for (EntityPlayer entityplayer : worldServerIn.field_73010_i) {
            if (entityplayer.func_175149_v()) continue;
            int j = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int k = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int l = 8;
            for (int i1 = -8; i1 <= 8; ++i1) {
                for (int j1 = -8; j1 <= 8; ++j1) {
                    PlayerChunkMapEntry playerchunkmapentry;
                    boolean flag = i1 == -8 || i1 == 8 || j1 == -8 || j1 == 8;
                    ChunkPos chunkpos = new ChunkPos(i1 + j, j1 + k);
                    if (this.eligibleChunksForSpawning.contains(chunkpos)) continue;
                    ++i;
                    if (flag || !worldServerIn.func_175723_af().func_177730_a(chunkpos) || (playerchunkmapentry = worldServerIn.func_184164_w().func_187301_b(chunkpos.field_77276_a, chunkpos.field_77275_b)) == null || !playerchunkmapentry.func_187274_e()) continue;
                    this.eligibleChunksForSpawning.add(chunkpos);
                }
            }
        }
        int j4 = 0;
        BlockPos blockpos1 = worldServerIn.func_175694_M();
        for (EnumCreatureType enumcreaturetype : EnumCreatureType.values()) {
            int l4;
            int k4;
            if (enumcreaturetype.func_75599_d() && !spawnPeacefulMobs || !enumcreaturetype.func_75599_d() && !spawnHostileMobs || enumcreaturetype.func_82705_e() && !spawnOnSetTickRate || (k4 = worldServerIn.countEntities(enumcreaturetype, true)) > (l4 = (enumcreaturetype.func_75601_b() + MMConfigSpawns.getSpawnLimitIncrease(enumcreaturetype)) * i / MOB_COUNT_DIV)) continue;
            ArrayList shuffled = Lists.newArrayList(this.eligibleChunksForSpawning);
            Collections.shuffle(shuffled);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            block7: for (ChunkPos chunkpos1 : shuffled) {
                BlockPos blockpos = MMWorldSpawner.getRandomChunkPosition((World)worldServerIn, chunkpos1.field_77276_a, chunkpos1.field_77275_b);
                int k1 = blockpos.func_177958_n();
                int l1 = blockpos.func_177956_o();
                int i2 = blockpos.func_177952_p();
                IBlockState iblockstate = worldServerIn.func_180495_p(blockpos);
                if (iblockstate.func_185915_l()) continue;
                int j2 = 0;
                block8: for (int k2 = 0; k2 < 3; ++k2) {
                    int l2 = k1;
                    int i3 = l1;
                    int j3 = i2;
                    int k3 = 6;
                    Biome.SpawnListEntry biome$spawnlistentry = null;
                    IEntityLivingData ientitylivingdata = null;
                    int l3 = MathHelper.func_76143_f((double)(Math.random() * 4.0));
                    for (int i4 = 0; i4 < l3; ++i4) {
                        EntityLiving entityliving;
                        blockpos$mutableblockpos.func_181079_c(l2 += worldServerIn.field_73012_v.nextInt(6) - worldServerIn.field_73012_v.nextInt(6), i3 += worldServerIn.field_73012_v.nextInt(1) - worldServerIn.field_73012_v.nextInt(1), j3 += worldServerIn.field_73012_v.nextInt(6) - worldServerIn.field_73012_v.nextInt(6));
                        float f = (float)l2 + 0.5f;
                        float f1 = (float)j3 + 0.5f;
                        if (worldServerIn.func_175636_b((double)f, (double)i3, (double)f1, 24.0) || !(blockpos1.func_177954_c((double)f, (double)i3, (double)f1) >= 576.0)) continue;
                        if (biome$spawnlistentry == null && (biome$spawnlistentry = worldServerIn.func_175734_a(enumcreaturetype, (BlockPos)blockpos$mutableblockpos)) == null) continue block8;
                        if (!worldServerIn.func_175732_a(enumcreaturetype, biome$spawnlistentry, (BlockPos)blockpos$mutableblockpos) || !MMWorldSpawner.canCreatureTypeSpawnAtLocation(EntitySpawnPlacementRegistry.func_180109_a((Class)biome$spawnlistentry.field_76300_b), (World)worldServerIn, (BlockPos)blockpos$mutableblockpos)) continue;
                        try {
                            entityliving = biome$spawnlistentry.newInstance((World)worldServerIn);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return j4;
                        }
                        if (entityliving == null) continue;
                        entityliving.func_70012_b((double)f, (double)i3, (double)f1, worldServerIn.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)worldServerIn, (float)f, (float)i3, (float)f1, (boolean)false);
                        if (canSpawn == Event.Result.ALLOW || canSpawn == Event.Result.DEFAULT && entityliving.func_70601_bi() && entityliving.func_70058_J()) {
                            if (!ForgeEventFactory.doSpecialSpawn((EntityLiving)entityliving, (World)worldServerIn, (float)f, (float)i3, (float)f1)) {
                                ientitylivingdata = entityliving.func_180482_a(worldServerIn.func_175649_E(new BlockPos((Entity)entityliving)), ientitylivingdata);
                            }
                            if (entityliving.func_70058_J()) {
                                ++j2;
                                worldServerIn.func_72838_d((Entity)entityliving);
                            } else {
                                entityliving.func_70106_y();
                            }
                            if (j2 >= ForgeEventFactory.getMaxSpawnPackSize((EntityLiving)entityliving)) continue block7;
                        }
                        j4 += j2;
                    }
                }
            }
        }
        return j4;
    }

    private static BlockPos getRandomChunkPosition(World worldIn, int x, int z) {
        Chunk chunk = worldIn.func_72964_e(x, z);
        int i = x * 16 + worldIn.field_73012_v.nextInt(16);
        int j = z * 16 + worldIn.field_73012_v.nextInt(16);
        int k = MathHelper.func_154354_b((int)(chunk.func_177433_f(new BlockPos(i, 0, j)) + 1), (int)16);
        int l = worldIn.field_73012_v.nextInt(k > 0 ? k : chunk.func_76625_h() + 16 - 1);
        return new BlockPos(i, l, j);
    }

    public static boolean isValidEmptySpawnBlock(IBlockState state) {
        if (state.func_185898_k()) {
            return false;
        }
        if (state.func_185897_m()) {
            return false;
        }
        if (state.func_185904_a().func_76224_d()) {
            return false;
        }
        return !BlockRailBase.func_176563_d((IBlockState)state);
    }

    public static boolean canCreatureTypeSpawnAtLocation(EntityLiving.SpawnPlacementType spawnPlacementTypeIn, World worldIn, BlockPos pos) {
        if (!worldIn.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        return spawnPlacementTypeIn.canSpawnAt(worldIn, pos);
    }

    public static boolean canCreatureTypeSpawnBody(EntityLiving.SpawnPlacementType spawnPlacementTypeIn, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (spawnPlacementTypeIn == EntityLiving.SpawnPlacementType.IN_WATER) {
            return iblockstate.func_185904_a() == Material.field_151586_h && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h && !worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        }
        BlockPos blockpos = pos.func_177977_b();
        IBlockState state = worldIn.func_180495_p(blockpos);
        if (!state.func_177230_c().canCreatureSpawn(state, (IBlockAccess)worldIn, blockpos, spawnPlacementTypeIn)) {
            return false;
        }
        Block block = worldIn.func_180495_p(blockpos).func_177230_c();
        boolean flag = block != Blocks.field_150357_h && block != Blocks.field_180401_cv;
        return flag && MMWorldSpawner.isValidEmptySpawnBlock(iblockstate) && MMWorldSpawner.isValidEmptySpawnBlock(worldIn.func_180495_p(pos.func_177984_a()));
    }

    public static void performWorldGenSpawning(World worldIn, Biome biomeIn, int centerX, int centerZ, int diameterX, int diameterZ, Random randomIn) {
        List list = biomeIn.func_76747_a(EnumCreatureType.CREATURE);
        if (!list.isEmpty()) {
            while (randomIn.nextFloat() < biomeIn.func_76741_f()) {
                Biome.SpawnListEntry biome$spawnlistentry = (Biome.SpawnListEntry)WeightedRandom.func_76271_a((Random)worldIn.field_73012_v, (List)list);
                int i = biome$spawnlistentry.field_76301_c + randomIn.nextInt(1 + biome$spawnlistentry.field_76299_d - biome$spawnlistentry.field_76301_c);
                IEntityLivingData ientitylivingdata = null;
                int j = centerX + randomIn.nextInt(diameterX);
                int k = centerZ + randomIn.nextInt(diameterZ);
                int l = j;
                int i1 = k;
                for (int j1 = 0; j1 < i; ++j1) {
                    boolean flag = false;
                    for (int k1 = 0; !flag && k1 < 4; ++k1) {
                        BlockPos blockpos = worldIn.func_175672_r(new BlockPos(j, 0, k));
                        if (MMWorldSpawner.canCreatureTypeSpawnAtLocation(EntityLiving.SpawnPlacementType.ON_GROUND, worldIn, blockpos)) {
                            EntityLiving entityliving;
                            try {
                                entityliving = biome$spawnlistentry.newInstance(worldIn);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue;
                            }
                            if (ForgeEventFactory.canEntitySpawn((EntityLiving)entityliving, (World)worldIn, (float)((float)j + 0.5f), (float)blockpos.func_177956_o(), (float)((float)k + 0.5f), (boolean)false) == Event.Result.DENY) continue;
                            entityliving.func_70012_b((double)((float)j + 0.5f), (double)blockpos.func_177956_o(), (double)((float)k + 0.5f), randomIn.nextFloat() * 360.0f, 0.0f);
                            worldIn.func_72838_d((Entity)entityliving);
                            ientitylivingdata = entityliving.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entityliving)), ientitylivingdata);
                            flag = true;
                        }
                        j += randomIn.nextInt(5) - randomIn.nextInt(5);
                        k += randomIn.nextInt(5) - randomIn.nextInt(5);
                        while (j < centerX || j >= centerX + diameterX || k < centerZ || k >= centerZ + diameterX) {
                            j = l + randomIn.nextInt(5) - randomIn.nextInt(5);
                            k = i1 + randomIn.nextInt(5) - randomIn.nextInt(5);
                        }
                    }
                }
            }
        }
    }
}

