/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.message;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.daveyx0.multimob.common.capabilities.CapabilityVariantEntity;
import net.daveyx0.multimob.common.capabilities.IVariantEntity;
import net.daveyx0.multimob.core.MultiMob;
import net.daveyx0.multimob.util.EntityUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageMMVariant
implements IMessage {
    private String entityId;
    private int variantId;

    public MessageMMVariant() {
    }

    public MessageMMVariant(String entityInID, int variantId) {
        this.entityId = entityInID;
        this.variantId = variantId;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.variantId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entityId);
        buf.writeInt(this.variantId);
    }

    public static class Handler
    implements IMessageHandler<MessageMMVariant, IMessage> {
        public IMessage onMessage(MessageMMVariant message, MessageContext ctx) {
            MultiMob.proxy.getThreadListener(ctx).func_152344_a(() -> {
                EntityLivingBase entity;
                if (!message.entityId.isEmpty() && (entity = EntityUtil.getLoadedEntityByUUID(UUID.fromString(message.entityId), MultiMob.proxy.getClientWorld())) != null && entity.hasCapability(CapabilityVariantEntity.VARIANT_ENTITY_CAPABILITY, null)) {
                    IVariantEntity variant = EntityUtil.getCapability((Entity)entity, CapabilityVariantEntity.VARIANT_ENTITY_CAPABILITY, null);
                    variant.setVariant(message.variantId);
                }
            });
            return null;
        }
    }
}

