/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.entity.ai;

import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.world.World;

public class EntityAIStealFromPlayer
extends EntityAIBase {
    private final EntityCreature temptedEntity;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    private EntityPlayer temptingPlayer;
    private boolean isRunning;
    private final Set<ItemStack> temptItem;
    private boolean canGetScared;
    private int stealDelay = 0;

    public EntityAIStealFromPlayer(EntityCreature temptedEntityIn, double speedIn, Set<ItemStack> temptItemIn, boolean canGetScared) {
        this.temptedEntity = temptedEntityIn;
        this.speed = speedIn;
        this.temptItem = temptItemIn;
        this.canGetScared = canGetScared;
        if (!(temptedEntityIn.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.temptedEntity.func_110144_aD() != null && this.canGetScared && this.stealDelay <= 0) {
            this.func_75251_c();
            return false;
        }
        if (!this.temptedEntity.func_184614_ca().func_190926_b()) {
            return false;
        }
        this.temptingPlayer = this.temptedEntity.func_130014_f_().func_72890_a((Entity)this.temptedEntity, 10.0);
        if (this.stealDelay > 0) {
            --this.stealDelay;
            if (this.stealDelay == 0) {
                this.temptedEntity.func_130011_c(null);
            }
            return false;
        }
        if (this.temptingPlayer != null) {
            for (int i = 0; i < this.temptingPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = this.temptingPlayer.field_71071_by.func_70301_a(i);
                if (item.func_190926_b() || !this.isTempting(item)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTempting(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (ItemStack item : this.temptItem) {
                if (item == null || item.func_77973_b() != stack.func_77973_b() || item.func_77960_j() != stack.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75249_e() {
        this.targetX = this.temptingPlayer.field_70165_t;
        this.targetY = this.temptingPlayer.field_70163_u;
        this.targetZ = this.temptingPlayer.field_70161_v;
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.temptingPlayer = null;
        this.temptedEntity.func_70661_as().func_75499_g();
        this.isRunning = false;
        if (this.canGetScared) {
            this.stealDelay = 100;
        }
    }

    public void func_75246_d() {
        this.temptedEntity.func_70671_ap().func_75651_a((Entity)this.temptingPlayer, (float)(this.temptedEntity.func_184649_cE() + 20), (float)this.temptedEntity.func_70646_bf());
        if (this.temptedEntity.func_70068_e((Entity)this.temptingPlayer) < 3.25) {
            this.temptedEntity.func_70661_as().func_75499_g();
            for (int i = 0; i < this.temptingPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = this.temptingPlayer.field_71071_by.func_70301_a(i);
                if (item.func_190926_b()) continue;
                for (ItemStack itemstack : this.temptItem) {
                    if (itemstack == null || itemstack.func_190926_b() || itemstack.func_77973_b() != item.func_77973_b() || itemstack.func_77960_j() != item.func_77960_j()) continue;
                    World world = this.temptingPlayer.func_130014_f_();
                    this.temptingPlayer.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                    ItemStack loot = item.func_77979_a(1);
                    this.temptedEntity.func_184201_a(EntityEquipmentSlot.MAINHAND, loot);
                    if (!this.temptingPlayer.field_71075_bZ.field_75098_d) {
                        item.func_190918_g(1);
                    }
                    return;
                }
            }
        } else {
            this.temptedEntity.func_70661_as().func_75497_a((Entity)this.temptingPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

