/*
 * Decompiled with CFR 0.152.
 */
package requious.util.color;

import java.awt.Color;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import requious.util.Misc;
import requious.util.color.ICustomColor;

public class EnergyColor
implements ICustomColor {
    List<Color> colors;
    boolean hsbMix;

    public EnergyColor(List<Color> colors, boolean hsbMix) {
        this.colors = colors;
        this.hsbMix = hsbMix;
    }

    @Override
    public Color get() {
        return this.colors.get(0);
    }

    @Override
    public Color get(ItemStack stack) {
        IEnergyStorage battery = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        double lerp = 0.0;
        if (battery != null) {
            lerp = (double)battery.getEnergyStored() / (double)battery.getMaxEnergyStored();
        }
        if (this.hsbMix) {
            return Misc.lerpColorHSB(this.colors, lerp);
        }
        return Misc.lerpColorRGB(this.colors, lerp);
    }
}

