/*
 * Decompiled with CFR 0.152.
 */
package requious.recipe;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import requious.compat.crafttweaker.IWorldFunction;
import requious.compat.crafttweaker.RecipeContainer;
import requious.compat.crafttweaker.SlotVisualCT;
import requious.compat.jei.JEISlot;
import requious.data.AssemblyData;
import requious.data.AssemblyProcessor;
import requious.data.component.ComponentBase;
import requious.recipe.ConsumptionResult;
import requious.recipe.IRecipeFunction;
import requious.recipe.MatchResult;
import requious.recipe.RequirementActive;
import requious.recipe.RequirementBase;
import requious.recipe.RequirementDuration;
import requious.recipe.RequirementEnergy;
import requious.recipe.RequirementFluid;
import requious.recipe.RequirementIngredient;
import requious.recipe.RequirementJEI;
import requious.recipe.RequirementLaser;
import requious.recipe.RequirementSelection;
import requious.recipe.RequirementWorld;
import requious.recipe.ResultBase;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.requious.AssemblyRecipe")
public class AssemblyRecipe {
    List<RequirementBase> requirements = new ArrayList<RequirementBase>();
    IRecipeFunction function;
    boolean jeiGenerated;
    AssemblyData jeiCategory;
    public List<JEISlot> jeiSlots = new ArrayList<JEISlot>();
    public String processGroup = "";

    public AssemblyRecipe(IRecipeFunction function) {
        this.function = function;
    }

    @ZenMethod
    public static AssemblyRecipe create(IRecipeFunction function) {
        return new AssemblyRecipe(function);
    }

    @ZenMethod
    public AssemblyRecipe requireItem(String group, IIngredient ingredient) {
        this.requirements.add(new RequirementIngredient(group, ingredient));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireItem(String group, IIngredient ingredient, int min, int max) {
        this.requirements.add(new RequirementIngredient(group, ingredient, min, max));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireFluid(String group, ILiquidStack ingredient) {
        this.requirements.add(new RequirementFluid(group, ingredient));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireFluid(String group, ILiquidStack ingredient, int min, int max) {
        this.requirements.add(new RequirementFluid(group, ingredient, min, max));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireEnergy(String group, int energy, @Optional String mark) {
        this.requirements.add(new RequirementEnergy(group, energy, mark));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireEnergy(String group, int min, int max, @Optional String mark) {
        this.requirements.add(new RequirementEnergy(group, min, max, mark));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireLaser(String group, int energy, @Optional String mark, @Optional SlotVisualCT slotVisual) {
        this.requirements.add(new RequirementLaser(group, energy, mark, SlotVisualCT.unpack(slotVisual)));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireLaser(String group, String type, int energy, @Optional String mark, @Optional SlotVisualCT slotVisual) {
        this.requirements.add(new RequirementLaser(group, type, energy, mark, SlotVisualCT.unpack(slotVisual)));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireSelection(String group, IItemStack stack, boolean reset) {
        this.requirements.add(new RequirementSelection(group, CraftTweakerMC.getItemStack((IItemStack)stack), reset));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireDuration(String group, int duration) {
        this.requirements.add(new RequirementDuration(group, duration));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireWorldCondition(String group, IWorldFunction function, int interval) {
        this.requirements.add(new RequirementWorld(group, function, interval));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe requireRandomChance(String group, double chance, int interval) {
        this.requirements.add(new RequirementWorld(group, container -> this.doesRandomApply(container.getTile().func_145831_w(), interval, chance), 0L));
        return this;
    }

    private boolean doesRandomApply(World world, int interval, double chance) {
        long seed = (long)this.hashCode() + world.func_82737_E() % (long)interval;
        return new Random(seed).nextDouble() > chance;
    }

    @ZenMethod
    public AssemblyRecipe addJEIInfo(String group, String langKey, SlotVisualCT slotVisual) {
        this.requirements.add(new RequirementJEI(group, langKey, SlotVisualCT.unpack(slotVisual)));
        return this;
    }

    @ZenMethod
    public AssemblyRecipe setSubProcess(String processGroup) {
        this.processGroup = processGroup;
        return this;
    }

    @ZenMethod
    public AssemblyRecipe setActive(int time) {
        this.requirements.add(new RequirementActive(time));
        return this;
    }

    public List<ConsumptionResult> matches(AssemblyProcessor assembly, RecipeContainer container) {
        List<ComponentBase.Slot> slots = assembly.getSlots();
        ArrayList<ConsumptionResult> results = new ArrayList<ConsumptionResult>();
        for (RequirementBase requirement : this.requirements) {
            ConsumptionResult result = requirement.createResult();
            results.add(result);
            boolean matched = false;
            MatchResult worldMatch = requirement.matches(assembly, result);
            if (worldMatch == MatchResult.MATCHED) {
                matched = true;
            }
            if (worldMatch == MatchResult.CANCEL) {
                return null;
            }
            if (!matched) {
                for (int i = 0; i < slots.size(); ++i) {
                    ComponentBase.Slot slot = slots.get(i);
                    MatchResult match = requirement.matches(slot, result);
                    if (match == MatchResult.MATCHED) {
                        matched = true;
                        result.setSlot(slot);
                        requirement.fillContainer(slot, result, container);
                        break;
                    }
                    if (match == MatchResult.CANCEL) break;
                }
            }
            if (matched) continue;
            return null;
        }
        return results;
    }

    public boolean fitsResults(AssemblyProcessor assembly, RecipeContainer container) {
        List<ComponentBase.Slot> slots = assembly.getSlots();
        HashSet<Integer> blockedSlots = new HashSet<Integer>();
        for (ResultBase result : container.getResults()) {
            boolean matched = false;
            if (result.matches(assembly)) {
                matched = true;
            }
            if (!matched) {
                for (int i = 0; i < slots.size(); ++i) {
                    ComponentBase.Slot slot = slots.get(i);
                    if (blockedSlots.contains(i) || !result.matches(slot)) continue;
                    blockedSlots.add(i);
                    matched = true;
                }
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public void consumeRequirements(List<ConsumptionResult> results) {
        for (ConsumptionResult result : results) {
            result.consume();
        }
    }

    public void produceResults(AssemblyProcessor assembly, RecipeContainer container) {
        List<ComponentBase.Slot> slots = assembly.getSlots();
        block0: for (ResultBase result : container.getResults()) {
            result.produce(assembly);
            for (ComponentBase.Slot slot : slots) {
                if (!result.matches(slot)) continue;
                result.produce(slot);
                continue block0;
            }
        }
    }

    public void calculate(RecipeContainer container) {
        this.function.calculate(container);
    }

    public void setJEICategory(AssemblyData assembly) {
        this.jeiCategory = assembly;
    }

    public void generateJEI() {
        if (!this.jeiGenerated) {
            for (JEISlot slot : this.jeiCategory.jeiSlots) {
                this.jeiSlots.add(slot.copy());
            }
            for (RequirementBase requirement : this.requirements) {
                JEISlot slot;
                boolean filled;
                Iterator<JEISlot> iterator = this.jeiSlots.iterator();
                while (iterator.hasNext() && !(filled = requirement.fillJEI(slot = iterator.next()))) {
                }
            }
            RecipeContainer container = new RecipeContainer(true);
            this.calculate(container);
            for (ResultBase result : container.getResults()) {
                JEISlot slot;
                boolean filled;
                Iterator<JEISlot> iterator = this.jeiSlots.iterator();
                while (iterator.hasNext() && !(filled = result.fillJEI(slot = iterator.next()))) {
                }
            }
            this.jeiGenerated = true;
        }
    }

    public boolean hasJEICategory() {
        return this.jeiCategory != null;
    }
}

