/*
 * Decompiled with CFR 0.152.
 */
package requious.network.message;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import requious.gui.ContainerAssembly;
import requious.gui.slot.BaseSlot;

public class MessageClickSlot
implements IMessage {
    int slot;
    ItemStack dragStack;
    int mouseButton;
    ClickType clickType;

    public MessageClickSlot() {
    }

    public MessageClickSlot(int slot, ItemStack dragStack, int mouseButton, ClickType clickType) {
        this.slot = slot;
        this.dragStack = dragStack;
        this.mouseButton = mouseButton;
        this.clickType = clickType;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        this.slot = buffer.readInt();
        try {
            this.dragStack = buffer.func_150791_c();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.mouseButton = buffer.readInt();
        this.clickType = this.readClickType(buffer.readInt());
    }

    private ClickType readClickType(int i) {
        ClickType[] values = ClickType.values();
        if (i < 0 || i >= values.length) {
            return ClickType.PICKUP;
        }
        return values[i];
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer buffer = new PacketBuffer(buf);
        buffer.writeInt(this.slot);
        buffer.func_150788_a(this.dragStack);
        buffer.writeInt(this.mouseButton);
        buffer.writeInt(this.writeClickType(this.clickType));
    }

    private int writeClickType(ClickType clickType) {
        if (clickType == null) {
            return 0;
        }
        return clickType.ordinal();
    }

    public static class MessageHolder
    implements IMessageHandler<MessageClickSlot, IMessage> {
        public IMessage onMessage(MessageClickSlot message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                Slot slot;
                Container container = player.field_71070_bA;
                if (container instanceof ContainerAssembly && (slot = container.func_75139_a(message.slot)) instanceof BaseSlot) {
                    ((BaseSlot)slot).serverClick(player, message.dragStack, message.mouseButton, message.clickType);
                }
            });
            return null;
        }
    }
}

