/*
 * Decompiled with CFR 0.152.
 */
package requious.entity.spark;

import java.awt.Color;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import requious.entity.EntitySpark;
import requious.entity.ISparkValue;
import requious.entity.SparkEffect;
import requious.util.FluidColorHelper;

public class ValueFluid
implements ISparkValue {
    FluidStack fluid;

    private ValueFluid() {
    }

    public ValueFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public int getAmount() {
        if (this.fluid == null) {
            return 0;
        }
        return this.fluid.amount;
    }

    @Override
    public float getSize(EntitySpark spark) {
        return 1.0f;
    }

    @Override
    public Color getColor(EntitySpark spark) {
        return new Color(FluidColorHelper.getColor(this.fluid), true);
    }

    @Override
    public SparkEffect getEffect(EntitySpark spark) {
        return SparkEffect.LightningBall;
    }

    @Override
    public int getLifetime(EntitySpark spark) {
        return 80;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("fluid", (NBTBase)this.fluid.writeToNBT(new NBTTagCompound()));
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("fluid"));
    }

    public static class Deserializer
    implements ISparkValue.Deserializer {
        @Override
        public ISparkValue deserialize(NBTTagCompound compound) {
            if (compound.func_74764_b("fluid")) {
                return new ValueFluid();
            }
            return null;
        }
    }
}

